/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.recipe.QualityData;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class RecipeImpl<I>
implements Recipe<I> {
    private final String recipeName;
    private final double brewDifficulty;
    @NotNull
    private final List<BrewingStep> steps;
    @NotNull
    private final QualityData<RecipeResult<I>> recipeResults;

    private RecipeImpl(String recipeName, double brewDifficulty, List<BrewingStep> steps, @NotNull QualityData<RecipeResult<I>> recipeResults) {
        this.recipeName = recipeName;
        this.brewDifficulty = brewDifficulty;
        this.steps = steps;
        this.recipeResults = recipeResults;
    }

    @Override
    @NotNull
    @Generated
    public List<BrewingStep> getSteps() {
        return this.steps;
    }

    @Override
    @NotNull
    @Generated
    public QualityData<RecipeResult<I>> getRecipeResults() {
        return this.recipeResults;
    }

    @Override
    @Generated
    public String getRecipeName() {
        return this.recipeName;
    }

    @Override
    @Generated
    public double getBrewDifficulty() {
        return this.brewDifficulty;
    }

    public static class Builder<I> {
        private final String recipeName;
        private double brewDifficulty = 1.0;
        private QualityData<RecipeResult<I>> recipeResult;
        private List<BrewingStep> steps;

        public Builder(String recipeName) {
            this.recipeName = recipeName;
        }

        public Builder<I> brewDifficulty(double brewDifficulty) {
            this.brewDifficulty = brewDifficulty;
            return this;
        }

        public Builder<I> recipeResults(@NotNull QualityData<RecipeResult<I>> recipeResult) {
            this.recipeResult = (QualityData)Preconditions.checkNotNull(recipeResult);
            return this;
        }

        public Builder<I> steps(@NotNull List<BrewingStep> steps) {
            this.steps = (List)Preconditions.checkNotNull(steps);
            return this;
        }

        public RecipeImpl<I> build() {
            Preconditions.checkNotNull(this.recipeResult);
            Preconditions.checkNotNull(this.steps);
            if (this.steps.isEmpty()) {
                throw new IllegalStateException("Steps should not be empty");
            }
            return new RecipeImpl<I>(this.recipeName, this.brewDifficulty, this.steps, this.recipeResult);
        }
    }
}

