/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.database;

import dev.jsinco.brewery.database.FindableStoredData;
import dev.jsinco.brewery.database.InsertableStoredData;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.RemovableStoredData;
import dev.jsinco.brewery.database.RetrievableStoredData;
import dev.jsinco.brewery.database.SingletonStoredData;
import dev.jsinco.brewery.database.UpdateableStoredData;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public interface PersistenceHandler<C> {
    default public <T> List<T> retrieveAllNow(RetrievableStoredData<T, C> dataType) throws PersistenceException {
        try {
            return this.retrieveAll(dataType).join();
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PersistenceException) {
                PersistenceException persistenceException = (PersistenceException)throwable;
                throw persistenceException;
            }
            throw new PersistenceException(e.getCause());
        }
    }

    public <T> CompletableFuture<List<T>> retrieveAll(RetrievableStoredData<T, C> var1) throws PersistenceException;

    public <T> CompletableFuture<Void> remove(RemovableStoredData<T, C> var1, T var2) throws PersistenceException;

    public <T> CompletableFuture<Void> updateValue(UpdateableStoredData<T, C> var1, T var2) throws PersistenceException;

    public <T> CompletableFuture<Void> insertValue(InsertableStoredData<T, C> var1, T var2) throws PersistenceException;

    default public <T, U> List<T> findNow(FindableStoredData<T, U, C> dataType, U searchObject) throws PersistenceException {
        try {
            return this.find(dataType, searchObject).join();
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PersistenceException) {
                PersistenceException persistenceException = (PersistenceException)throwable;
                throw persistenceException;
            }
            throw new PersistenceException(e.getCause());
        }
    }

    public <T, U> CompletableFuture<List<T>> find(FindableStoredData<T, U, C> var1, U var2) throws PersistenceException;

    default public <T> T getSingletonNow(SingletonStoredData<T, C> dataType) throws PersistenceException {
        try {
            return this.getSingleton(dataType).join();
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PersistenceException) {
                PersistenceException persistenceException = (PersistenceException)throwable;
                throw persistenceException;
            }
            throw new PersistenceException(e.getCause());
        }
    }

    public <T> CompletableFuture<T> getSingleton(SingletonStoredData<T, C> var1) throws PersistenceException;

    public <T> CompletableFuture<Void> setSingleton(SingletonStoredData<T, C> var1, T var2) throws PersistenceException;

    public CompletableFuture<Void> flush();
}

