/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.configuration.EventSection;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationUtil {
    @NotNull
    public static UUID resolveWorld(String worldNameOrUUID) {
        World world;
        try {
            world = Bukkit.getWorld((UUID)UUID.fromString(worldNameOrUUID));
        }
        catch (IllegalArgumentException e) {
            world = Bukkit.getWorld((String)worldNameOrUUID);
        }
        if (world == null) {
            throw new IllegalArgumentException("Could not find world: " + worldNameOrUUID);
        }
        return world.getUID();
    }

    @NotNull
    public static Location safeLocationInRadius(Location location, int radius) {
        Location center = location.clone();
        World world = center.getWorld();
        if (world == null || radius <= 0) {
            Location loc = LocationUtil.safeLocationHere(center);
            return loc != null ? loc : center;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 50; ++i) {
            int dz;
            int dx = random.nextInt(-radius, radius + 1);
            if (dx * dx + (dz = random.nextInt(-radius, radius + 1)) * dz > radius * radius) continue;
            int x = center.getBlockX() + dx;
            int z = center.getBlockZ() + dz;
            Location loc = new Location(world, (double)x + 0.5, (double)world.getMaxHeight(), (double)z + 0.5, center.getYaw(), center.getPitch());
            Location candidate = LocationUtil.safeLocationHere(loc);
            if (!LocationUtil.isSafe(candidate)) continue;
            return candidate;
        }
        Location loc = LocationUtil.safeLocationHere(center);
        return loc != null ? loc : center;
    }

    @Nullable
    public static Location safeLocationHere(Location location) {
        Location loc = location.clone();
        if (LocationUtil.isSafe(loc)) {
            return loc;
        }
        if (loc.getWorld() == null) {
            return null;
        }
        loc.setY((double)loc.getWorld().getHighestBlockYAt(loc));
        if (ThreadLocalRandom.current().nextInt(100) >= EventSection.events().undergroundChance()) {
            loc.add(0.0, 1.0, 0.0);
        }
        while (loc.getY() >= (double)loc.getWorld().getMinHeight()) {
            if (LocationUtil.isSafe(loc)) {
                return loc;
            }
            loc.setY(loc.getY() - 1.0);
        }
        return null;
    }

    public static boolean isSafe(Location location) {
        if (location == null) {
            return false;
        }
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        if (location.getY() < (double)world.getMinHeight() || location.getY() > (double)world.getMaxHeight()) {
            return false;
        }
        Block below = location.getBlock().getRelative(BlockFace.DOWN);
        Block head = location.getBlock().getRelative(BlockFace.UP);
        if (below.isSolid() && !LocationUtil.isDangerousBlock(below.getType())) {
            return LocationUtil.isEmptyOrPassable(location.getBlock().getType()) && LocationUtil.isEmptyOrPassable(head.getType());
        }
        return location.getBlock().getType() == Material.WATER && below.getType() == Material.WATER && LocationUtil.isEmptyOrPassable(head.getType());
    }

    private static boolean isEmptyOrPassable(Material type) {
        if (type.isAir()) {
            return true;
        }
        if (type == Material.WATER || type == Material.LAVA || type == Material.CACTUS || type == Material.SWEET_BERRY_BUSH || type == Material.FIRE || type == Material.SOUL_FIRE || type == Material.COBWEB || type == Material.POWDER_SNOW) {
            return false;
        }
        return !type.isSolid() && !type.isOccluding();
    }

    private static boolean isDangerousBlock(Material type) {
        return switch (type) {
            case Material.LAVA, Material.FIRE, Material.SOUL_FIRE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.MAGMA_BLOCK, Material.CACTUS, Material.SWEET_BERRY_BUSH, Material.WITHER_ROSE, Material.POWDER_SNOW -> true;
            default -> false;
        };
    }

    public static boolean isWithinBuildLimit(Location location) {
        World world = location.getWorld();
        return world.getMinHeight() <= location.getBlockY() && location.getBlockY() <= world.getMaxHeight();
    }
}

