/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure.serializer;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class MaterialHolderSerializer
implements ObjectSerializer<Holder.Material> {
    @Override
    public boolean supports(@NonNull Class<? super Holder.Material> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Holder.Material.class == type;
    }

    @Override
    public void serialize( @NonNull Holder.Material object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(object.value().minimalized("minecraft"));
    }

    @Override
    public Holder.Material deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String value = data.getValue(String.class);
        NamespacedKey key = NamespacedKey.fromString((String)value);
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)("Invalid key: " + value));
        Material material = (Material)Registry.MATERIAL.get(key);
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)("Unknown material with key: " + String.valueOf(key)));
        return BukkitAdapter.toMaterialHolder(material);
    }
}

