/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.bukkit.structure.BlockDataMatcher;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.Schematic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class BreweryStructure {
    private final Schematic schem;
    private final EntryPoints entryPoints;
    private final String name;
    private final Meta meta;
    private final String schemFileName;

    public BreweryStructure(@NotNull Schematic schem, @NotNull String name, Meta structureMeta, String schemFileName) {
        this(schem, new EntryPoints(BreweryStructure.computeEntryPoints(schem), false), name, structureMeta, schemFileName);
    }

    public BreweryStructure(@NotNull Schematic schem, @NotNull EntryPoints origins, @NotNull String name, Meta structureMeta, String schemFileName) {
        this.schem = Objects.requireNonNull(schem);
        this.entryPoints = origins;
        this.name = Objects.requireNonNull(name);
        this.meta = Objects.requireNonNull(structureMeta);
        this.schemFileName = schemFileName;
    }

    private static List<Vector3i> computeEntryPoints(Schematic schem) {
        ArrayList vector3iList = new ArrayList();
        schem.apply(new Matrix3d(), (position, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            vector3iList.add(position);
        });
        return List.copyOf(vector3iList);
    }

    public <T> Optional<Location> findValidOrigin(Matrix3d transformation, Location entryPoint, BlockDataMatcher<T> blockDataMatcher, T matcherType) {
        Preconditions.checkNotNull((Object)entryPoint.getWorld(), (Object)"World for entry point can not be null!");
        for (Vector3i structureEntryPoint : this.entryPoints.entryPoints()) {
            Vector3d transformedEntryPoint = transformation.transform(new Vector3d((Vector3ic)structureEntryPoint));
            Location worldOrigin = entryPoint.clone().subtract((double)((int)transformedEntryPoint.x()), (double)((int)transformedEntryPoint.y()), (double)((int)transformedEntryPoint.z()));
            if (!this.matches(transformation, worldOrigin, blockDataMatcher, matcherType)) continue;
            return Optional.of(worldOrigin);
        }
        return Optional.empty();
    }

    private <T> boolean matches(Matrix3d transformation, Location structureWorldOrigin, BlockDataMatcher<T> blockDataMatcher, T matcherType) {
        Map<Location, BlockData> expectedBlocks = this.getExpectedBlocks(transformation, structureWorldOrigin);
        for (Map.Entry<Location, BlockData> expected : expectedBlocks.entrySet()) {
            World world = expected.getKey().getWorld();
            if (!world.getWorldBorder().isInside(expected.getKey()) || world.getMinHeight() > expected.getKey().getBlockY() || world.getMaxHeight() <= expected.getKey().getBlockY()) {
                return false;
            }
            if (blockDataMatcher.matches(expected.getKey().getBlock().getBlockData(), expected.getValue(), matcherType)) continue;
            return false;
        }
        return true;
    }

    public Map<Location, BlockData> getExpectedBlocks(Matrix3d transformation, Location structureWorldOrigin) {
        Preconditions.checkNotNull((Object)structureWorldOrigin.getWorld(), (Object)"World for world origin can not be null!");
        HashMap<Location, BlockData> output = new HashMap<Location, BlockData>();
        this.schem.apply(transformation, (schematicSpacePosition, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            output.put(structureWorldOrigin.clone().add((double)schematicSpacePosition.x(), (double)schematicSpacePosition.y(), (double)schematicSpacePosition.z()), (BlockData)blockData);
        });
        return output;
    }

    public List<BlockData> getPalette() {
        return Arrays.asList(this.schem.palette());
    }

    @Nullable
    public <V> V getMeta(StructureMeta<V> meta) {
        return (V)this.meta.data().get(meta);
    }

    public <V> V getMetaOrDefault(StructureMeta<V> meta, V defaultValue) {
        return (V)this.meta.data().getOrDefault(meta, defaultValue);
    }

    public boolean hasMeta(StructureMeta<?> metaKey) {
        return this.meta.data().containsKey(metaKey);
    }

    @Generated
    public EntryPoints getEntryPoints() {
        return this.entryPoints;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Meta getMeta() {
        return this.meta;
    }

    @Generated
    public String getSchemFileName() {
        return this.schemFileName;
    }

    public record EntryPoints(List<Vector3i> entryPoints, boolean customDefinition) {
    }

    public record Meta(Map<StructureMeta<?>, Object> data) {
    }
}

