/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.api.effect.ModifierConsume;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.effect.modifier.ModifierDisplay;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.effect.ConsumedModifierDisplay;
import dev.jsinco.brewery.bukkit.effect.ModifierConsumePdcType;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffect;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffectPersistentDataType;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.bukkit.util.ListPersistentDataType;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeEffects {
    public static final NamespacedKey COMMANDS = TheBrewingProject.key("commands");
    public static final NamespacedKey MESSAGE = TheBrewingProject.key("message");
    public static final NamespacedKey ACTION_BAR = TheBrewingProject.key("action_bar");
    public static final NamespacedKey TITLE = TheBrewingProject.key("titles");
    public static final NamespacedKey ALCOHOL = TheBrewingProject.key("alcohol");
    public static final NamespacedKey TOXINS = TheBrewingProject.key("toxins");
    public static final NamespacedKey MODIFIERS = TheBrewingProject.key("modifiers");
    public static final NamespacedKey EVENTS = TheBrewingProject.key("events");
    public static final NamespacedKey EFFECTS = TheBrewingProject.key("effects");
    private static final List<NamespacedKey> PDC_TYPES = List.of(COMMANDS, MESSAGE, ACTION_BAR, TITLE, ALCOHOL, TOXINS, EVENTS);
    public static final RecipeEffects GENERIC = new Builder().effects(List.of()).build();
    @NotNull
    private final List<RecipeEffect> effects;
    @Nullable
    private final String title;
    @Nullable
    private final String message;
    @Nullable
    private final String actionBar;
    @NotNull
    private final Map<DrunkenModifier, Double> modifiers;
    @NotNull
    private final List<BreweryKey> events;

    private RecipeEffects(@NotNull List<RecipeEffect> effects, @Nullable String title, @Nullable String message, @Nullable String actionBar, @NotNull List<BreweryKey> events, @NotNull Map<DrunkenModifier, Double> modifiers) {
        this.effects = effects;
        this.title = title;
        this.message = message;
        this.actionBar = actionBar;
        this.modifiers = modifiers;
        this.events = events;
    }

    public List<DrunkEvent> getEvents() {
        CustomEventRegistry customEventRegistry = TheBrewingProject.getInstance().getCustomDrunkEventRegistry();
        return this.events.stream().map(eventKey -> {
            if (BreweryRegistry.DRUNK_EVENT.containsKey((BreweryKey)eventKey)) {
                return BreweryRegistry.DRUNK_EVENT.get((BreweryKey)eventKey);
            }
            return customEventRegistry.getCustomEvent((BreweryKey)eventKey);
        }).filter(Objects::nonNull).toList();
    }

    public void applyTo(ItemStack itemStack) {
        itemStack.editPersistentDataContainer(this::applyTo);
    }

    private void applyTo(PersistentDataContainer container) {
        PDC_TYPES.forEach(arg_0 -> ((PersistentDataContainer)container).remove(arg_0));
        if (this.title != null) {
            container.set(TITLE, PersistentDataType.STRING, (Object)this.title);
        }
        if (this.message != null) {
            container.set(MESSAGE, PersistentDataType.STRING, (Object)this.message);
        }
        if (this.actionBar != null) {
            container.set(ACTION_BAR, PersistentDataType.STRING, (Object)this.actionBar);
        }
        if (!this.modifiers.isEmpty()) {
            container.set(MODIFIERS, ModifierConsumePdcType.LIST_INSTANCE, this.modifiers.entrySet().stream().map(entry -> new ModifierConsume((DrunkenModifier)entry.getKey(), (Double)entry.getValue())).toList());
        }
        if (!this.events.isEmpty()) {
            container.set(EVENTS, ListPersistentDataType.STRING_LIST, this.events.stream().map(BreweryKey::toString).toList());
        }
        if (!this.effects.isEmpty()) {
            container.set(EFFECTS, RecipeEffectPersistentDataType.INSTANCE, this.effects);
        }
    }

    public static Optional<RecipeEffects> fromEntity(Entity entity) {
        return RecipeEffects.fromPdc((PersistentDataContainerView)entity.getPersistentDataContainer());
    }

    private static Optional<RecipeEffects> fromPdc(PersistentDataContainerView persistentDataContainer) {
        List consumeModifiers;
        Builder builder = new Builder();
        HashMap<DrunkenModifier, Double> modifiers = new HashMap<DrunkenModifier, Double>();
        DrunkenModifierSection.modifiers().optionalModifier("alcohol").filter(modifier -> persistentDataContainer.has(ALCOHOL, PersistentDataType.INTEGER)).ifPresent(modifier -> modifiers.put((DrunkenModifier)modifier, Double.valueOf(((Integer)persistentDataContainer.get(ALCOHOL, PersistentDataType.INTEGER)).intValue())));
        DrunkenModifierSection.modifiers().optionalModifier("toxins").filter(modifier -> persistentDataContainer.has(TOXINS, PersistentDataType.INTEGER)).ifPresent(modifier -> modifiers.put((DrunkenModifier)modifier, Double.valueOf(((Integer)persistentDataContainer.get(TOXINS, PersistentDataType.INTEGER)).intValue())));
        if (persistentDataContainer.has(TITLE)) {
            builder.title((String)persistentDataContainer.get(TITLE, PersistentDataType.STRING));
        }
        if (persistentDataContainer.has(MESSAGE)) {
            builder.message((String)persistentDataContainer.get(MESSAGE, PersistentDataType.STRING));
        }
        if (persistentDataContainer.has(ACTION_BAR)) {
            builder.actionBar((String)persistentDataContainer.get(ACTION_BAR, PersistentDataType.STRING));
        }
        if ((consumeModifiers = (List)persistentDataContainer.get(MODIFIERS, ModifierConsumePdcType.LIST_INSTANCE)) != null) {
            consumeModifiers.stream().filter(Objects::nonNull).forEach(modifierConsume -> modifiers.put(modifierConsume.modifier(), modifierConsume.value()));
        }
        builder.addModifiers(modifiers);
        builder.events(((List)persistentDataContainer.getOrDefault(EVENTS, ListPersistentDataType.STRING_LIST, List.of())).stream().map(BreweryKey::parse).collect(Collectors.toList()));
        if (persistentDataContainer.has(EFFECTS, RecipeEffectPersistentDataType.INSTANCE)) {
            builder.effects((List)persistentDataContainer.get(EFFECTS, RecipeEffectPersistentDataType.INSTANCE));
        }
        RecipeEffects output = builder.build();
        if (output.effects.isEmpty() && output.modifiers.isEmpty() && output.events.isEmpty() && output.actionBar == null && output.message == null && output.title == null) {
            return Optional.empty();
        }
        return Optional.of(builder.build());
    }

    public static Optional<RecipeEffects> fromItem(@NotNull ItemStack item) {
        return RecipeEffects.fromPdc(item.getPersistentDataContainer());
    }

    public void applyTo(Player player) {
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        DrunkState beforeState = ((DrunksManagerImpl)drunksManager).getDrunkState(player.getUniqueId());
        DrunkState afterState = null;
        if (!player.hasPermission("brewery.override.drunk")) {
            afterState = ((DrunksManagerImpl)drunksManager).consume(player.getUniqueId(), this.modifiers.entrySet().stream().map(entry -> new ModifierConsume((DrunkenModifier)entry.getKey(), (Double)entry.getValue(), true)).toList());
        }
        if (this.title != null) {
            player.showTitle(Title.title((Component)MessageUtil.miniMessage(this.title, BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player), MessageUtil.numberedModifierTagResolver(this.modifiers, "consumed")), (Component)Component.empty()));
        } else {
            ConsumedModifierDisplay.renderConsumeDisplay(player, ModifierDisplay.DisplayWindow.TITLE, beforeState, afterState, this.modifiers);
        }
        if (this.message != null) {
            player.sendMessage(MessageUtil.miniMessage(this.message, BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player), MessageUtil.numberedModifierTagResolver(this.modifiers, "consumed")));
        } else {
            ConsumedModifierDisplay.renderConsumeDisplay(player, ModifierDisplay.DisplayWindow.CHAT, beforeState, afterState, this.modifiers);
        }
        if (this.actionBar != null) {
            player.sendActionBar(MessageUtil.miniMessage(this.actionBar, BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player), MessageUtil.numberedModifierTagResolver(this.modifiers, "consumed")));
        } else {
            ConsumedModifierDisplay.renderConsumeDisplay(player, ModifierDisplay.DisplayWindow.ACTION_BAR, beforeState, afterState, this.modifiers);
        }
        if (player.hasPermission("brewery.override.effect")) {
            return;
        }
        this.getEvents().forEach(drunkEvent -> TheBrewingProject.getInstance().getDrunkEventExecutor().doDrunkEvent(player.getUniqueId(), (DrunkEvent)drunkEvent));
        this.getEffects().stream().map(RecipeEffect::newPotionEffect).forEach(arg_0 -> ((Player)player).addPotionEffect(arg_0));
    }

    public void applyTo(Projectile projectile) {
        PersistentDataContainer persistentDataContainer = projectile.getPersistentDataContainer();
        this.applyTo(persistentDataContainer);
    }

    @NotNull
    @Generated
    public List<RecipeEffect> getEffects() {
        return this.effects;
    }

    @Nullable
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Nullable
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public String getActionBar() {
        return this.actionBar;
    }

    @NotNull
    @Generated
    public Map<DrunkenModifier, Double> getModifiers() {
        return this.modifiers;
    }

    public static class Builder
    implements dev.jsinco.brewery.api.util.Builder<RecipeEffects> {
        private List<RecipeEffect> effects = List.of();
        @Nullable
        private String title;
        @Nullable
        private String message;
        @Nullable
        private String actionBar;
        @NotNull
        private List<BreweryKey> events = List.of();
        private final ImmutableMap.Builder<DrunkenModifier, Double> modifiers = new ImmutableMap.Builder();

        public Builder effects(@NotNull List<RecipeEffect> effects) {
            Preconditions.checkNotNull(effects);
            this.effects = effects;
            return this;
        }

        public Builder events(@NotNull List<BreweryKey> events) {
            Preconditions.checkNotNull(events);
            this.events = List.copyOf(events);
            return this;
        }

        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public Builder actionBar(@Nullable String actionBar) {
            this.actionBar = actionBar;
            return this;
        }

        public Builder addModifiers(Map<DrunkenModifier, Double> modifiers) {
            this.modifiers.putAll(modifiers);
            return this;
        }

        @Override
        public RecipeEffects build() {
            return new RecipeEffects(this.effects, this.title, this.message, this.actionBar, this.events, (Map<DrunkenModifier, Double>)this.modifiers.build());
        }
    }
}

