/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.bukkit.util.BlockUtil;
import dev.jsinco.brewery.bukkit.util.LocationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HallucinationNamedExecutable
implements EventPropertyExecutable {
    private static final int BLOCK_RANGE = 20;
    private static final int TARGET_SEARCH_ATTEMPTS = 10;
    private static final List<Vector> ONE_BLOCK_OFFSETS = HallucinationNamedExecutable.generateOffsets();
    @Nullable
    private static List<BlockType> REPLACEMENT_BLOCKS = null;
    private static final Set<Material> CANNOT_REPLACE = EnumSet.of(Material.MAGMA_BLOCK, Material.SLIME_BLOCK, Material.BARRIER);
    private static final Set<Material> PROBLEMATIC_REPLACEMENT_BLOCKS = EnumSet.of(Material.MAGMA_BLOCK, new Material[]{Material.SLIME_BLOCK, Material.BARRIER, Material.SPAWNER, Material.TRIAL_SPAWNER, Material.VAULT});

    private static List<Vector> generateOffsets() {
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    offsets.add(new Vector(x, y, z));
                }
            }
        }
        return offsets;
    }

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        Block lookingAt = player.getTargetBlock(null, 20);
        Hallucination hallucination = HallucinationNamedExecutable.attemptHallucination(lookingAt);
        if (hallucination == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        Block target = hallucination.target();
        BlockType replacement = hallucination.replacement();
        BlockData blockData = replacement.createBlockData();
        player.sendBlockChange(target.getLocation(), blockData);
        player.spawnParticle(Particle.DUST, target.getLocation().toCenterLocation(), 10, 0.5, 0.5, 0.5, (Object)new Particle.DustOptions(blockData.getMapColor(), 1.0f));
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Nullable
    private static Hallucination attemptHallucination(Block searchCenter) {
        BlockType replacement;
        if (HallucinationNamedExecutable.canReplace(searchCenter) && (replacement = HallucinationNamedExecutable.getReplacementBlock(searchCenter)) != null) {
            return new Hallucination(searchCenter, replacement);
        }
        Location searchCenterLocation = searchCenter.getLocation();
        List candidateLocations = ONE_BLOCK_OFFSETS.stream().map(offset -> searchCenterLocation.clone().add(offset)).filter(LocationUtil::isWithinBuildLimit).filter(Location::isChunkLoaded).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(candidateLocations);
        for (int i = 0; i < 10; ++i) {
            BlockType replacement2;
            Block possibleTarget = ((Location)candidateLocations.get(i)).getBlock();
            if (!HallucinationNamedExecutable.canReplace(possibleTarget) || (replacement2 = HallucinationNamedExecutable.getReplacementBlock(possibleTarget)) == null) continue;
            return new Hallucination(possibleTarget, replacement2);
        }
        return null;
    }

    private static boolean canReplace(Block toReplace) {
        return !CANNOT_REPLACE.contains(toReplace.getType()) && toReplace.isSolid() && BlockUtil.isFullBlock(toReplace);
    }

    @Nullable
    private static BlockType getReplacementBlock(Block target) {
        BlockType targetType = Objects.requireNonNull(target.getType().asBlockType());
        List<BlockType> candidates = HallucinationNamedExecutable.getReplacementBlocks(target.getWorld()).stream().filter(replacement -> HallucinationNamedExecutable.isSensibleReplacement(replacement, targetType)).toList();
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.get(RANDOM.nextInt(candidates.size()));
    }

    private static boolean isSensibleReplacement(BlockType replacement, BlockType target) {
        return !replacement.equals((Object)target) && replacement.getSlipperiness() == target.getSlipperiness() && HallucinationNamedExecutable.replacementCannotBeMinedFaster(replacement, target);
    }

    private static boolean replacementCannotBeMinedFaster(BlockType replacement, BlockType target) {
        return target.getHardness() <= replacement.getHardness() && BlockUtil.getFasterTools(target).containsAll(BlockUtil.getFasterTools(replacement));
    }

    private static List<BlockType> getReplacementBlocks(World world) {
        if (REPLACEMENT_BLOCKS == null) {
            REPLACEMENT_BLOCKS = HallucinationNamedExecutable.computeReplacementBlocks(world);
        }
        return REPLACEMENT_BLOCKS;
    }

    private static List<BlockType> computeReplacementBlocks(World world) {
        return Arrays.stream(Material.values()).filter(material -> !PROBLEMATIC_REPLACEMENT_BLOCKS.contains(material)).filter(material -> HallucinationNamedExecutable.isFullSolidOpaqueBlock(material, world)).map(Material::asBlockType).toList();
    }

    private static boolean isFullSolidOpaqueBlock(Material material, World world) {
        if (material.isAir() || material.isLegacy()) {
            return false;
        }
        BlockType blockType = material.asBlockType();
        if (blockType == null) {
            return false;
        }
        if (!blockType.isSolid() || !blockType.isOccluding()) {
            return false;
        }
        Location sampleLocation = new Location(world, 0.0, 0.0, 0.0);
        return BlockUtil.isFullBlock(material.createBlockData().getCollisionShape(sampleLocation));
    }

    @Override
    public int priority() {
        return -1;
    }

    private record Hallucination(Block target, BlockType replacement) {
    }
}

