/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.barrel;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.Barrel;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BrewInventory;
import dev.jsinco.brewery.bukkit.breweries.barrel.BarrelBrewPersistenceHandler;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.util.SoundPlayer;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitBarrel
implements Barrel<BukkitBarrel, ItemStack, Inventory> {
    private final PlacedBreweryStructure<BukkitBarrel> structure;
    private final int size;
    private final BarrelType type;
    private final Location uniqueLocation;
    private final BrewInventory inventory;
    private long recentlyAccessed = -1L;
    private long ticksUntilNextCheck = 0L;
    private static final Random RANDOM = new Random();

    public BukkitBarrel(Location uniqueLocation, @NotNull PlacedBreweryStructure<BukkitBarrel> structure, int size, @NotNull BarrelType type) {
        this.structure = (PlacedBreweryStructure)Preconditions.checkNotNull(structure);
        this.size = size;
        this.type = (BarrelType)Preconditions.checkNotNull((Object)type);
        this.uniqueLocation = (Location)Preconditions.checkNotNull((Object)uniqueLocation);
        this.inventory = new BrewInventory((Component)Component.translatable((String)"tbp.barrel.gui-title"), size, new BarrelBrewPersistenceHandler(BukkitAdapter.toBreweryLocation(uniqueLocation)));
    }

    @Override
    public boolean open(@NotNull BreweryLocation location, @NotNull UUID playerUuid) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (!player.hasPermission("brewery.barrel.access")) {
            MessageUtil.message((Audience)player, "tbp.barrel.access-denied", new TagResolver[0]);
            return true;
        }
        if (this.inventoryUnpopulated()) {
            this.inventory.updateInventoryFromBrews();
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        if (this.uniqueLocation != null) {
            SoundPlayer.playSoundEffect(Config.config().sounds().barrelOpen(), Sound.Source.BLOCK, this.uniqueLocation.toCenterLocation());
        }
        player.openInventory(this.inventory.getInventory());
        return true;
    }

    @Override
    public boolean inventoryAllows(@NotNull UUID playerUuid, @NotNull ItemStack item) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return false;
        }
        if (!player.hasPermission("brewery.barrel.access")) {
            MessageUtil.message((Audience)player, "tbp.barrel.access-denied", new TagResolver[0]);
            return false;
        }
        return this.inventoryAllows(item);
    }

    @Override
    public boolean inventoryAllows(@NotNull ItemStack item) {
        return BrewAdapter.fromItem(item).isPresent();
    }

    @Override
    public Set<Inventory> getInventories() {
        return Set.of(this.inventory.getInventory());
    }

    @Override
    public void close(boolean silent) {
        this.ticksUntilNextCheck = 0L;
        Brew[] previousBrews = Arrays.copyOf(this.inventory.getBrews(), this.inventory.getBrews().length);
        this.inventory.updateBrewsFromInventory();
        this.processBrews(previousBrews);
        if (!silent && this.uniqueLocation != null) {
            SoundPlayer.playSoundEffect(Config.config().sounds().barrelClose(), Sound.Source.BLOCK, this.uniqueLocation.toCenterLocation());
        }
        this.inventory.getInventory().clear();
    }

    @Override
    public void tickInventory() {
        if (this.shouldUnpopulateInventory()) {
            this.close(false);
            TheBrewingProject.getInstance().getBreweryRegistry().unregisterOpened(this);
            this.recentlyAccessed = -1L;
            return;
        }
        if (!this.inventory.getInventory().getViewers().isEmpty()) {
            this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        }
        if (this.ticksUntilNextCheck-- > 0L) {
            return;
        }
        this.ticksUntilNextCheck = Math.min(Config.config().barrels().agingYearTicks() / 20L, 6000L);
        Brew[] previousBrews = Arrays.copyOf(this.inventory.getBrews(), this.inventory.getBrews().length);
        this.inventory.updateBrewsFromInventory();
        this.processBrews(previousBrews);
        this.inventory.updateInventoryFromBrews();
        this.getInventory().getInventory().getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).forEach(Player::updateInventory);
    }

    private void processBrews(Brew[] previousBrews) {
        Brew[] brews = this.inventory.getBrews();
        long time = TheBrewingProject.getInstance().getTime();
        for (int i = 0; i < brews.length; ++i) {
            BrewingStep.Age age;
            Brew brew = brews[i];
            if (brew == null) continue;
            BrewingStep brewingStep = brew.lastStep();
            if (!(brewingStep instanceof BrewingStep.Age) || (age = (BrewingStep.Age)brewingStep).barrelType() != this.type) {
                brew = brew.withStep(new AgeStepImpl(new Interval(time, time), this.type));
                this.inventory.store(brew, i);
                continue;
            }
            brews[i] = Objects.equals(previousBrews[i], brew) ? brew.withLastStep(BrewingStep.Age.class, age1 -> age1.withAge(age.time().withLastStep(time)), () -> new AgeStepImpl(new Interval(time, time), this.type)) : brew.withLastStep(BrewingStep.Age.class, age1 -> age1.withAge(age.time().withMovedEnding(time)), () -> new AgeStepImpl(new Interval(time, time), this.type));
        }
    }

    @Override
    public Optional<Inventory> access(@NotNull BreweryLocation breweryLocation) {
        if (this.inventoryUnpopulated()) {
            this.inventory.updateInventoryFromBrews();
            TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        return Optional.of(this.inventory.getInventory());
    }

    @Override
    public void destroy(BreweryLocation breweryLocation) {
        BukkitAdapter.toLocation(breweryLocation).map(location -> location.add(0.5, 0.0, 0.5)).ifPresent(location -> {
            if (!this.inventoryUnpopulated()) {
                this.inventory.updateBrewsFromInventory();
            }
            List<ItemStack> contents = this.inventory.destroy();
            contents.forEach(itemStack -> location.getWorld().dropItem(location, itemStack));
        });
    }

    @Override
    public PlacedBreweryStructure<BukkitBarrel> getStructure() {
        return this.structure;
    }

    World getWorld() {
        return this.uniqueLocation.getWorld();
    }

    public List<Pair<Brew, Integer>> getBrews() {
        ArrayList<Pair<Brew, Integer>> brewList = new ArrayList<Pair<Brew, Integer>>();
        for (int i = 0; i < this.inventory.getBrews().length; ++i) {
            if (this.inventory.getBrews()[i] == null) continue;
            brewList.add(new Pair<Brew, Integer>(this.inventory.getBrews()[i], i));
        }
        return brewList;
    }

    private boolean inventoryUnpopulated() {
        return this.recentlyAccessed == -1L;
    }

    private boolean shouldUnpopulateInventory() {
        return this.recentlyAccessed == -1L || this.recentlyAccessed + 20L <= TheBrewingProject.getInstance().getTime();
    }

    @Generated
    public BrewInventory getInventory() {
        return this.inventory;
    }

    @Generated
    public long getRecentlyAccessed() {
        return this.recentlyAccessed;
    }

    @Generated
    public long getTicksUntilNextCheck() {
        return this.ticksUntilNextCheck;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public BarrelType getType() {
        return this.type;
    }

    @Generated
    public Location getUniqueLocation() {
        return this.uniqueLocation;
    }
}

