/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.event;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.EventStepProperty;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryKeyed;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import java.util.Locale;
import net.kyori.adventure.text.Component;

public class NamedDrunkEvent
implements DrunkEvent,
BreweryKeyed,
EventStepProperty {
    private final String name;
    @SerializedName(value="probability")
    private final EventProbability eventProbability;
    @Expose(serialize=false, deserialize=false)
    private BreweryKey key;

    public NamedDrunkEvent(String name, EventProbability eventProbability) {
        this.name = name;
        this.eventProbability = eventProbability;
        this.key = BreweryKey.parse(name);
    }

    @Override
    public BreweryKey key() {
        if (this.key == null) {
            this.key = BreweryKey.parse(this.name);
        }
        return this.key;
    }

    @Override
    public Component displayName() {
        return Component.translatable((String)("tbp.events.types." + this.name.toLowerCase(Locale.ROOT)));
    }

    @Override
    public EventProbability probability() {
        return this.eventProbability;
    }

    public static NamedDrunkEvent fromKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        return BreweryRegistry.DRUNK_EVENT.get(BreweryKey.parse(key));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NamedDrunkEvent)) {
            return false;
        }
        NamedDrunkEvent namedOther = (NamedDrunkEvent)other;
        return this.key.equals(namedOther.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

