/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect.text;

import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.effect.text.DrunkTextElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public record DrunkTextPattern(Pattern pattern, String text, int percentage, DrunkenModifier modifier, double minValue) implements DrunkTextElement
{
    private static final Random RANDOM = new Random();

    @Override
    @NotNull
    public List<DrunkTextElement.TextTransformation> findTransform(String initial) {
        Matcher matcher = this.pattern.matcher(initial);
        ArrayList<DrunkTextElement.TextTransformation> output = new ArrayList<DrunkTextElement.TextTransformation>();
        while (matcher.find()) {
            if (this.percentage < RANDOM.nextInt(0, 101)) continue;
            output.add(this.compileTransformFromMatch(matcher.toMatchResult()));
        }
        return output;
    }

    private DrunkTextElement.TextTransformation compileTransformFromMatch(MatchResult matchResult) {
        String text;
        String string = matchResult.group();
        boolean isCaps = string.equals(string.toUpperCase(Locale.ROOT)) && !string.equals(string.toLowerCase(Locale.ROOT));
        String string2 = text = isCaps ? this.text().toUpperCase(Locale.ROOT) : this.text().toLowerCase(Locale.ROOT);
        if (matchResult.groupCount() > 0) {
            Pair<Integer, Integer> range = this.findRange(matchResult);
            int start = matchResult.start();
            return new DrunkTextElement.TextTransformation(text, range.first() + start, range.second() + start);
        }
        return new DrunkTextElement.TextTransformation(text, matchResult.start(), matchResult.end());
    }

    private Pair<Integer, Integer> findRange(MatchResult matchResult) {
        int matchStart = matchResult.start();
        int start = 0;
        int end = matchResult.end() - matchStart;
        for (int i = 1; i < matchResult.groupCount() + 1; ++i) {
            int groupEnd = matchResult.end(i) - matchStart;
            int groupStart = matchResult.start(i) - matchStart;
            if (groupStart <= start) {
                start = groupEnd;
                continue;
            }
            if (groupEnd < end) continue;
            end = groupStart;
        }
        return new Pair<Integer, Integer>(start, end);
    }
}

