/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.migration.breweryx;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewManager;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.PassedMoment;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.ingredient.SimpleIngredient;
import dev.jsinco.brewery.bukkit.migration.breweryx.NBTLoadStream;
import dev.jsinco.brewery.bukkit.migration.breweryx.XORUnscrambleStream;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import dev.jsinco.brewery.util.IngredientUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreweryXMigrationUtils {
    private static final List<BarrelType> BARREL_TYPES = List.of(BarrelType.ANY, BarrelType.BIRCH, BarrelType.OAK, BarrelType.JUNGLE, BarrelType.SPRUCE, BarrelType.ACACIA, BarrelType.DARK_OAK, BarrelType.CRIMSON, BarrelType.WARPED, BarrelType.MANGROVE, BarrelType.CHERRY, BarrelType.BAMBOO, BarrelType.COPPER, BarrelType.PALE_OAK);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ItemStack migrate(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        NBTLoadStream nbtStream = new NBTLoadStream(meta);
        if (!nbtStream.hasData()) {
            return null;
        }
        XORUnscrambleStream unscrambler = new XORUnscrambleStream((InputStream)nbtStream, Config.config().breweryxMigrationSeeds());
        try (DataInputStream in = new DataInputStream(unscrambler);){
            Record state;
            if (in.readByte() != 86) {
                Logger.logWarn("Parity check failed on BreweryX Brew while migrating. Trying to load it anyway...");
            }
            if (in.readByte() != 1) {
                Logger.log("Trying to convert a BreweryX Brew that stores data in an unsupported version...");
            }
            unscrambler.start();
            BrewData data = BreweryXMigrationUtils.loadBrewDataFromStream(in);
            BrewManager<ItemStack> brewManager = TheBrewingProject.getInstance().getBrewManager();
            Record record = state = data.sealed ? new Brew.State.Seal(null) : new Brew.State.Other();
            if (data.brew == null || data.sealed) {
                ItemStack itemStack = BreweryXMigrationUtils.itemFromDataWithoutSteps(data, brewManager, state);
                return itemStack;
            }
            ItemStack itemStack = brewManager.toItem(data.brew, (Brew.State)((Object)state));
            return itemStack;
        }
        catch (IOException | InvalidKeyException e) {
            Logger.logErr("Failed to convert a BreweryX Brew:");
            Logger.logErr(e);
            return null;
        }
    }

    private static ItemStack itemFromDataWithoutSteps(BrewData data, BrewManager<ItemStack> brewManager, Brew.State state) {
        BrewQuality quality;
        if (data.recipe == null) {
            Logger.logWarn("Failed to convert a BreweryX Brew: Couldn't extract recipe identifier.");
            return null;
        }
        Optional recipeOptional = ((RecipeRegistryImpl)TheBrewingProject.getInstance().getRecipeRegistry()).getRecipe(data.recipe);
        if (recipeOptional.isEmpty()) {
            Logger.logWarn("Failed to convert a BreweryX Brew: Recipe '" + data.recipe + "' not configured in TBP.");
            return null;
        }
        Recipe recipe = recipeOptional.get();
        ArrayList<BrewingStep> steps = new ArrayList<BrewingStep>(recipe.getSteps());
        Object e = steps.getFirst();
        if (e instanceof BrewingStep.Cook) {
            BrewingStep.Cook cookStep = (BrewingStep.Cook)e;
            steps.set(0, cookStep.withIngredients(IngredientUtil.sanitizeIngredients(cookStep.ingredients())));
        }
        if ((e = steps.getFirst()) instanceof BrewingStep.Mix) {
            BrewingStep.Mix mixStep = (BrewingStep.Mix)e;
            steps.set(0, mixStep.withIngredients(IngredientUtil.sanitizeIngredients(mixStep.ingredients())));
        }
        Brew brew = brewManager.createBrew(steps);
        BrewScore score = brew.score(recipe);
        BrewQuality brewQuality = data.quality >= 9 ? BrewQuality.EXCELLENT : (quality = data.quality >= 6 ? BrewQuality.GOOD : BrewQuality.BAD);
        if (score instanceof BrewScoreImpl) {
            BrewScoreImpl scoreImpl = (BrewScoreImpl)score;
            scoreImpl.setQualityOverride(quality);
        }
        return (ItemStack)recipe.getRecipeResult(quality).newBrewItem(score, brew, state);
    }

    private static BrewData loadBrewDataFromStream(DataInputStream in) throws IOException {
        byte quality = in.readByte();
        int flags = in.readUnsignedByte();
        if ((flags & 0x40) != 0) {
            in.skipBytes(2);
        }
        ArrayList<BrewingStep> steps = new ArrayList<BrewingStep>();
        if ((flags & 1) != 0) {
            steps.add(new DistillStepImpl(in.readByte()));
        }
        double ageTime = (flags & 2) != 0 ? (double)in.readFloat() : 0.0;
        int woodType = (flags & 4) != 0 ? (int)in.readFloat() : 0;
        if (ageTime != 0.0) {
            long ageInTicks = (long)((double)Config.config().barrels().agingYearTicks() * ageTime);
            BarrelType barrelType = woodType >= BARREL_TYPES.size() || woodType < 0 ? BarrelType.ANY : BARREL_TYPES.get(woodType);
            steps.add(new AgeStepImpl(new PassedMoment(ageInTicks), barrelType));
        }
        String recipe = null;
        if ((flags & 8) != 0) {
            recipe = in.readUTF();
        }
        boolean sealed = (flags & 0x80 | flags & 0x20) != 0;
        int cookingTime = in.readInt();
        int ingredientAmount = in.readByte();
        if (ingredientAmount == 0) {
            return new BrewData(null, recipe, true, quality);
        }
        HashMap<Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>();
        for (int i = 0; i < ingredientAmount; ++i) {
            Ingredient ingredient = BreweryXMigrationUtils.readIngredient(in);
            short amount = in.readShort();
            if (ingredient == null) continue;
            ingredients.put(ingredient, Integer.valueOf(amount));
        }
        steps.addFirst(new CookStepImpl(new PassedMoment((long)cookingTime * 1200L), ingredients, CauldronType.WATER));
        return new BrewData(new BrewImpl(steps), recipe, sealed, quality);
    }

    private static Ingredient readIngredient(DataInputStream in) throws IOException {
        return switch (in.readUTF().toUpperCase(Locale.ROOT)) {
            case "CI" -> BreweryXMigrationUtils.readCustomItem(in);
            case "PI" -> BreweryXMigrationUtils.readPluginItem(in);
            case "SI" -> BreweryXMigrationUtils.readSimpleItem(in);
            default -> throw new IOException("Unsupported ingredient type: " + String.valueOf(in));
        };
    }

    private static Ingredient readSimpleItem(DataInputStream in) throws IOException {
        String materialName = in.readUTF();
        in.skipBytes(2);
        return BreweryXMigrationUtils.parseSimpleIngredientWithLogMessage(materialName);
    }

    private static Ingredient parseSimpleIngredientWithLogMessage(String materialString) {
        try {
            return new SimpleIngredient(Material.valueOf((String)materialString));
        }
        catch (IllegalArgumentException e) {
            Logger.logWarn("Unknown material name for simple ingredient: " + materialString);
            return null;
        }
    }

    private static Ingredient readPluginItem(DataInputStream in) throws IOException {
        String pluginId = in.readUTF();
        String itemId = in.readUTF();
        Ingredient output = TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationTypes.ITEM).stream().filter(itemIntegration -> pluginId.equalsIgnoreCase(itemIntegration.getId())).map(itemIntegration -> itemIntegration.createIngredient(itemId).join()).flatMap(Optional::stream).findFirst().orElse(null);
        if (output == null) {
            Logger.logWarn("Unknown plugin id or item id for plugin ingredient: " + pluginId + ":" + itemId);
        }
        return output;
    }

    private static Ingredient readCustomItem(DataInputStream in) throws IOException {
        int loreSize;
        if (in.readBoolean()) {
            return BreweryXMigrationUtils.parseSimpleIngredientWithLogMessage(in.readUTF());
        }
        if (in.readBoolean()) {
            in.readUTF();
        }
        if ((loreSize = in.readShort()) > 0) {
            for (int i = 0; i < loreSize; ++i) {
                in.readUTF();
            }
        }
        if (in.readBoolean()) {
            in.skipBytes(4);
        }
        return null;
    }

    private record BrewData(@Nullable Brew brew, @Nullable String recipe, boolean sealed, byte quality) {
    }
}

