/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.structure;

import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.api.integration.StructureIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GriefPreventionIntegration
implements StructureIntegration {
    private static final boolean ENABLED = ClassUtil.exists("me.ryanhamshire.GriefPrevention.GriefPrevention");

    @Override
    public boolean hasAccess(Block block, Player player, BreweryKey type) {
        if (!ENABLED) {
            return true;
        }
        GriefPrevention griefPrevention = GriefPrevention.instance;
        if (griefPrevention == null || !griefPrevention.isEnabled()) {
            return true;
        }
        PlayerData playerData = griefPrevention.dataStore.getPlayerData(player.getUniqueId());
        if (!griefPrevention.claimsEnabledForWorld(player.getWorld()) || playerData.ignoreClaims || !griefPrevention.config_claims_preventTheft) {
            return true;
        }
        if (playerData.inPvpCombat()) {
            return false;
        }
        Claim claim = griefPrevention.dataStore.getClaimAt(block.getLocation(), false, playerData.lastClaim);
        if (claim != null) {
            String noContainersReason;
            playerData.lastClaim = claim;
            Supplier supplier = claim.checkPermission(player, ClaimPermission.Inventory, null);
            String string = noContainersReason = supplier != null ? (String)supplier.get() : null;
            if (noContainersReason != null) {
                return false;
            }
        }
        if (playerData.pvpImmune) {
            playerData.pvpImmune = false;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return ENABLED;
    }

    @Override
    public String getId() {
        return "griefprevention";
    }

    @Override
    public void onEnable() {
    }
}

