/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.bukkit.command.argument.OfflinePlayerSelectorArgumentResolver;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerArgument
implements CustomArgumentType<OfflinePlayerSelectorArgumentResolver, PlayerSelectorArgumentResolver> {
    private static final DynamicCommandExceptionType ERROR_INVALID_PLAYER = new DynamicCommandExceptionType(invalidPlayer -> BukkitMessageUtil.toBrigadier("tbp.command.unknown-player", new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)invalidPlayer.toString())}));
    private final ArgumentType<PlayerSelectorArgumentResolver> backing = ArgumentTypes.player();

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        return this.backing.listSuggestions(context, builder);
    }

    public OfflinePlayerSelectorArgumentResolver parse(StringReader reader) throws CommandSyntaxException {
        char startChar = reader.peek();
        if (startChar == '@') {
            PlayerSelectorArgumentResolver playerSelectorArgumentResolver = (PlayerSelectorArgumentResolver)this.backing.parse(reader);
            return commandSourceStack -> (OfflinePlayer)((List)playerSelectorArgumentResolver.resolve(commandSourceStack)).getFirst();
        }
        String playerName = reader.readString();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayerIfCached((String)playerName);
        if (offlinePlayer == null) {
            throw ERROR_INVALID_PLAYER.create((Object)playerName);
        }
        return ignored -> offlinePlayer;
    }

    @NotNull
    public ArgumentType<PlayerSelectorArgumentResolver> getNativeType() {
        return ArgumentTypes.player();
    }
}

