/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.command.argument.EnumArgument;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class InfoCommand {
    private static final int PLAYER_INVENTORY_SIZE = 41;

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        ArgumentBuilder withIndex = Commands.argument((String)"inventory_slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(context -> {
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            int slot = (Integer)context.getArgument("inventory_slot", Integer.TYPE);
            PlayerInventory inventory = target.getInventory();
            InfoCommand.showInfo(inventory.getItem(slot), ((CommandSourceStack)context.getSource()).getSender());
            return 1;
        });
        ArgumentBuilder withNamedSlot = Commands.argument((String)"equipment_slot", new EnumArgument<EquipmentSlot>(EquipmentSlot.class)).executes(context -> {
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            PlayerInventory inventory = target.getInventory();
            InfoCommand.showInfo(inventory.getItem((EquipmentSlot)context.getArgument("equipment_slot", EquipmentSlot.class)), ((CommandSourceStack)context.getSource()).getSender());
            return 1;
        });
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").then(withNamedSlot)).then(withIndex)).then(BreweryCommand.playerBranch(argument -> {
            argument.then(withNamedSlot);
            argument.then(withIndex);
            argument.executes(InfoCommand::showHeldItemInfo);
        }))).executes(InfoCommand::showHeldItemInfo);
    }

    private static int showHeldItemInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player target = BreweryCommand.getPlayer(context);
        PlayerInventory inventory = target.getInventory();
        InfoCommand.showInfo(inventory.getItemInMainHand(), ((CommandSourceStack)context.getSource()).getSender());
        return 1;
    }

    private static void showInfo(@Nullable ItemStack itemStack, CommandSender sender) {
        if (itemStack == null) {
            MessageUtil.message((Audience)sender, "tbp.command.info.not-a-brew", new TagResolver[0]);
            return;
        }
        Optional<Brew> brewOptional = BrewAdapter.fromItem(itemStack);
        brewOptional.ifPresent(brew -> {
            TagResolver[] tagResolverArray = new TagResolver[2];
            tagResolverArray[0] = MessageUtil.getScoreTagResolver(brew.closestRecipe(TheBrewingProject.getInstance().getRecipeRegistry()).map(brew::score).orElse(BrewScoreImpl.failed(brew)));
            tagResolverArray[1] = Placeholder.component((String)"brewing_step_info", (ComponentLike)((ComponentLike)MessageUtil.compileBrewInfo(brew, true, TheBrewingProject.getInstance().getRecipeRegistry()).collect(Component.toComponent((Component)Component.text((String)"\n")))));
            MessageUtil.message((Audience)sender, "tbp.command.info.message", tagResolverArray);
        });
        Optional<RecipeEffects> recipeEffectsOptional = RecipeEffects.fromItem(itemStack);
        recipeEffectsOptional.ifPresent(effects -> MessageUtil.message((Audience)sender, "tbp.command.info.effect-message", BukkitMessageUtil.recipeEffectResolver(effects)));
        if (brewOptional.isEmpty() && recipeEffectsOptional.isEmpty()) {
            MessageUtil.message((Audience)sender, "tbp.command.info.not-a-brew", new TagResolver[0]);
        }
    }
}

