/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record CookStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients, CauldronType cauldronType) implements BrewingStep.Cook
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.TIME), new PartialBrewScore(0.0, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    @Override
    public CookStepImpl withBrewTime(Moment brewTime) {
        return new CookStepImpl(brewTime, this.ingredients, this.cauldronType);
    }

    @Override
    public CookStepImpl withIngredients(Map<Ingredient, Integer> ingredients) {
        return new CookStepImpl(this.time, ingredients, this.cauldronType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherTime;
        Object object;
        if (!(other instanceof CookStepImpl)) return BREW_STEP_MISMATCH;
        CookStepImpl cookStepImpl = (CookStepImpl)other;
        try {
            object = cookStepImpl.time();
            otherTime = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherIngredients = object = cookStepImpl.ingredients();
        Object otherType = object = cookStepImpl.cauldronType();
        double cauldronTypeScore = this.cauldronType.equals(otherType) ? 1.0 : 0.0;
        double timeScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherTime.moment()));
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients, (Map<Ingredient, Integer>)otherIngredients);
        return Stream.of(new PartialBrewScore(cauldronTypeScore * timeScore, ScoreType.TIME), new PartialBrewScore(ingredientsScore, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.COOK;
    }

    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        return this.proximityScores(other);
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

