/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientGroup;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.ingredient.ScoredIngredient;
import dev.jsinco.brewery.api.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class BrewingStepUtil {
    public static double nearbyValueScore(long expected, long value) {
        double diff = Math.abs(expected - value);
        return 1.0 - Math.max(diff / (double)expected, 0.0);
    }

    public static double getIngredientsScore(Map<Ingredient, Integer> target, Map<Ingredient, Integer> actual) {
        List<Pair> customScores = actual.entrySet().stream().filter(entry -> entry.getKey() instanceof ScoredIngredient).map(entry -> new Pair<Double, Integer>(((ScoredIngredient)entry.getKey()).score(), (Integer)entry.getValue())).toList();
        Pair<Double, Integer> scoredIngredientPair = customScores.stream().reduce(new Pair<Double, Integer>(1.0, 1), (pair1, pair2) -> new Pair<Double, Integer>((Double)pair1.first() * Math.pow((Double)pair2.first(), ((Integer)pair2.second()).intValue()), (Integer)pair1.second() + (Integer)pair2.second()));
        double output = Math.pow(scoredIngredientPair.first(), 1.0 / (double)scoredIngredientPair.second().intValue());
        Map<Ingredient, Integer> modifiedTarget = BrewingStepUtil.compressIngredients(target);
        Map<Ingredient, Integer> modifiedActual = BrewingStepUtil.compressIngredients(actual);
        ArrayList<@Nullable Double> ingredientScores = new ArrayList<Double>();
        for (Map.Entry<Ingredient, Integer> targetEntry : List.copyOf(modifiedTarget.entrySet())) {
            int actualAmount;
            Ingredient ingredient = targetEntry.getKey();
            if (ingredient instanceof IngredientGroup) {
                IngredientGroup ingredientGroup = (IngredientGroup)ingredient;
                Pair<Integer, Double> ingredientGroupMatch = BrewingStepUtil.computeIngredientGroupMatch(ingredientGroup, modifiedActual, modifiedTarget, targetEntry.getValue());
                actualAmount = ingredientGroupMatch.first();
                ingredientScores.add(ingredientGroupMatch.second());
            } else {
                int n = actualAmount = modifiedActual.containsKey(ingredient) ? modifiedActual.remove(ingredient) : 0;
            }
            if (actualAmount == 0) {
                return 0.0;
            }
            output *= BrewingStepUtil.nearbyValueScore(targetEntry.getValue().intValue(), actualAmount);
        }
        if (!modifiedActual.isEmpty()) {
            return 0.0;
        }
        double ingredientScore = ingredientScores.isEmpty() ? 1.0 : ingredientScores.stream().filter(Objects::nonNull).reduce(1.0, (aDouble, aDouble2) -> aDouble * aDouble2);
        return output * ingredientScore;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Integer, @Nullable Double> computeIngredientGroupMatch(IngredientGroup ingredientGroup, Map<Ingredient, Integer> modifiedActual, Map<Ingredient, Integer> targetIngredients, int target) {
        Double d;
        int ingredientAmount = 0;
        double ingredientScoreSum = 0.0;
        int amountOfScoredIngredients = 0;
        ArrayList<Ingredient> postProcess = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredientGroup.alternatives()) {
            block10: {
                if (ingredient instanceof ScoredIngredient) {
                    int amount;
                    double score;
                    ScoredIngredient scoredIngredient = (ScoredIngredient)ingredient;
                    try {
                        double d2;
                        Ingredient ingredient2;
                        Ingredient baseIngredient = ingredient2 = scoredIngredient.baseIngredient();
                        score = d2 = scoredIngredient.score();
                        ingredient = baseIngredient;
                        if (targetIngredients.containsKey(ingredient) || !modifiedActual.containsKey(ingredient)) break block10;
                        amount = modifiedActual.get(ingredient);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    ingredientScoreSum += score * (double)amount;
                    amountOfScoredIngredients += amount;
                }
            }
            if (!modifiedActual.containsKey(ingredient)) continue;
            if (targetIngredients.containsKey(ingredient)) {
                postProcess.add(ingredient);
                continue;
            }
            ingredientAmount += modifiedActual.remove(ingredient).intValue();
        }
        for (Ingredient ingredient : postProcess) {
            if (target <= ingredientAmount) break;
            int amount = modifiedActual.getOrDefault(ingredient, 0);
            int increase = Math.min(amount, target - ingredientAmount);
            if (ingredient instanceof ScoredIngredient) {
                double score;
                Ingredient baseIngredient;
                ScoredIngredient scoredIngredient = (ScoredIngredient)ingredient;
                {
                    double d3;
                    Ingredient ingredient3;
                    baseIngredient = ingredient3 = scoredIngredient.baseIngredient();
                    score = d3 = scoredIngredient.score();
                }
                ingredientScoreSum += score * (double)increase;
                ingredient = baseIngredient;
                amountOfScoredIngredients += increase;
            }
            ingredientAmount += increase;
            if (amount == increase) {
                modifiedActual.remove(ingredient);
                continue;
            }
            modifiedActual.put(ingredient, amount - increase);
        }
        Integer n = ingredientAmount;
        if (amountOfScoredIngredients == 0) {
            d = null;
            return new Pair<Integer, Object>(n, d);
        }
        d = ingredientScoreSum / (double)amountOfScoredIngredients;
        return new Pair<Integer, Object>(n, d);
    }

    private static Map<Ingredient, Integer> compressIngredients(Map<Ingredient, Integer> ingredients) {
        HashMap<Ingredient, Integer> output = new HashMap<Ingredient, Integer>();
        ingredients.entrySet().stream().map(entry -> {
            Object patt0$temp = entry.getKey();
            if (patt0$temp instanceof ScoredIngredient) {
                ScoredIngredient scoredIngredient = (ScoredIngredient)patt0$temp;
                return new Pair<Ingredient, Integer>(scoredIngredient.baseIngredient(), (Integer)entry.getValue());
            }
            return new Pair<Ingredient, Integer>((Ingredient)entry.getKey(), (Integer)entry.getValue());
        }).forEach(pair -> IngredientManager.insertIngredientIntoMap(output, pair));
        return output;
    }
}

