/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.recipe;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface ScoreCondition {
    public boolean matches(@Nullable BrewingStep var1, BrewingStep var2);

    public static enum AmountCondition {
        EXCESSIVE,
        LACKING,
        ANY;


        public boolean matches(double value, double expected) {
            if (this == ANY) {
                return true;
            }
            if (expected == -1.0) {
                return false;
            }
            if (this == LACKING) {
                return value < expected;
            }
            return value > expected;
        }
    }

    public static interface IngredientsCondition
    extends ScoreCondition {
        public Map<Ingredient, AmountCondition> conditions();
    }

    public static interface SingletonCondition
    extends ScoreCondition {
        public AmountCondition amountCondition();

        public ScoreType type();
    }
}

