/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.recipe.QualityData;
import dev.jsinco.brewery.api.util.Builder;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityDataBuilder<T, B extends Builder<T>> {
    private final QualityData<B> elementBuilders = QualityData.fromValueMapper(ignored -> (Builder)elementBuilderSupplier.get());

    public QualityDataBuilder(Supplier<B> elementBuilderSupplier) {
    }

    public QualityDataBuilder<T, B> addString(@NotNull String value, String errorMessage, BiConsumer<B, String> action) {
        Preconditions.checkNotNull((Object)value, (Object)errorMessage);
        QualityData<String> stringQualityData = QualityData.readQualityFactoredString(value);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, (String)stringQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public <U> QualityDataBuilder<T, B> add(@NotNull String value, String errorMessage, Function<String, U> uMapper, BiConsumer<B, U> action) {
        Preconditions.checkNotNull((Object)value, (Object)errorMessage);
        QualityData uQualityData = QualityData.readQualityFactoredString(value).map(uMapper);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, uQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public QualityDataBuilder<T, B> addOptionalString(@Nullable String value, BiConsumer<B, String> action) {
        if (value == null) {
            return this;
        }
        QualityData<String> stringQualityData = QualityData.readQualityFactoredString(value);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, (String)stringQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public <U> QualityDataBuilder<T, B> addOptional(@Nullable String value, Function<String, U> uMapper, BiConsumer<B, U> action) {
        if (value == null) {
            return this;
        }
        QualityData uQualityData = QualityData.readQualityFactoredString(value).map(uMapper);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, uQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public QualityDataBuilder<T, B> addStringList(@NotNull List<String> values, String errorMessage, BiConsumer<B, List<String>> action) {
        Preconditions.checkNotNull(values, (Object)errorMessage);
        QualityData<List<String>> uQualityData = QualityData.readQualityFactoredStringList(values);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, (List)uQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public QualityDataBuilder<T, B> addOptionalStringList(@Nullable List<String> values, BiConsumer<B, List<String>> action) {
        if (values == null) {
            return this;
        }
        QualityData<List<String>> uQualityData = QualityData.readQualityFactoredStringList(values);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, (List)uQualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public <U> QualityDataBuilder<T, B> addOptionalList(List<String> values, Function<String, U> uMapper, BiConsumer<B, List<U>> action) {
        if (values == null) {
            return this;
        }
        QualityData<List<String>> uQualityData = QualityData.readQualityFactoredStringList(values);
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, ((List)uQualityData.get((BrewQuality)((Object)quality))).stream().map(uMapper).filter(Objects::nonNull).toList()));
        return this;
    }

    public <U> QualityDataBuilder<T, B> add(QualityData<U> qualityData, BiConsumer<B, U> action) {
        Preconditions.checkNotNull(qualityData, (Object)"Quality data can not be null!");
        this.elementBuilders.forEach((quality, builder) -> action.accept(builder, qualityData.get((BrewQuality)((Object)quality))));
        return this;
    }

    public QualityData<T> build() {
        return this.elementBuilders.map(Builder::build);
    }
}

