/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.format;

import dev.jsinco.brewery.configuration.Config;

public class TimeFormatHeader {
    public static String get() {
        return switch (Config.config().language().toLanguageTag()) {
            case "ru" -> TimeFormatHeader.russian();
            default -> TimeFormatHeader.english();
        };
    }

    private static String english() {
        return "#  +-----------------------------------------------------------------------------------+\n#  | This file is for specifying how time intervals should be formatted and displayed. |\n#  +-----------------------------------------------------------------------------------+\n#\n#  PLACEHOLDERS (will be replaced with the corresponding values):\n#\n#    Modular (leftover) values:\n#      These show the value of a unit after larger units have been subtracted.\n#      Available: <ticks>, <seconds>, <minutes>, <hours>, <days>, <years>, <decades>\n#      Example: in \"1 hour 45 minutes\", <minutes> = 45.\n#\n#    Total values (independent of higher units):\n#      These show the complete value of a unit, ignoring larger breakdowns.\n#      Available: <ticks-total>, <seconds-total>, <minutes-total>, <hours-total>, <days-total>, <years-total>\n#      Example: in \"1 hour 45 minutes\", <minutes-total> = 105.\n#\n#  CONDITIONAL BLOCKS:\n#\n#    <if-unit>...</if-unit>    ...Content is only shown if that unit is NOT zero\n#    <if-!unit>...</if-!unit>  ...Content is only shown if that unit IS zero\n#\n#    Example: \"<if-hours-total><hours-total>:</if-hours-total><minutes>:<seconds>\"\n#      => hours are only added for times above or equal to one hour (e.g. 1:45:00)\n#\n#  PLURALIZATION:\n#\n#    [text]  ...Shown only if the last number before it is NOT 1\n#    {text}  ...Shown only if the last number before it IS 1\n#\n#    Example: \"<minutes> minute[s]\" => 1 minute / 2 minutes\n#\n#    [text]<n>  ...Shown only if the last number before it is NOT n\n#    {text}<n>  ...Shown only if the last number before it IS n\n#\n#    Example: \"<ticks-total> {is five}<5>[is not five]<5>\" => 5 is five / 3 is not five\n#\n#    [text]<a-b>  ...Shown only if the last number before it is NOT in range a-b\n#    {text}<a-b>  ...Shown only if the last number before it IS in range a-b\n#\n#    Example: \"<ticks-total> {is in range}<2-4>[is not in range]<2-4>\" => 3 is in range / 5 is not in range\n#\n#    You can use double angled brackets to check for the last prior digit, not the whole number:\n#     => \"{text}<<a-b>>\"  ...Shown only if the last DIGIT before it is in range a-b\n#\n#    You can use triple angled brackets to check for the last TWO prior digits:\n#     => \"{text}<<<a-b>>>\"  ...Shown only if the last TWO DIGITS before it are in range a-b\n#\n#    Pluralization blocks can be nested with double and triple brackets, as they take higher priority:\n#     => \"<ticks> {{{text}<<5>>}}<0-100>\"  ...Shows \"text\" behind numbers that end on 5 in range 0 - 100\n#\n#  EXAMPLES:\n#\n#    \"2 days, 0 hours, 17 minutes and 1 second\", \"45 minutes and 30 seconds\":\n#\n#      \"<if-days-total><days-total> day[s], <if-!hours><hours> hour[s], </if-!hours></if-days-total>\n#       <if-hours><hours> hour[s], </if-hours><minutes> minute[s] and <seconds> second[s]\"\n#\n#    \"2 days, 17 minutes and 1 second\", \"45 minutes and 30 seconds\":\n#\n#      \"<if-days-total><days-total> day[s], </if-days-total><if-hours><hours> hour[s], </if-hours>\n#       <minutes> minute[s] and <seconds> second[s]\"\n#\n#    \"26:45:30\", \"25:00\", \"00:05\":\n#\n#      \"<if-hours-total><hours-total>:</if-hours-total><minutes>:<seconds>\"\n#\n#    \"85:45\", \"00:15\":\n#\n#      \"<minutes-total>:<seconds>\"\n#\n";
    }

    private static String russian() {
        return "#  +-----------------------------------------------------------------------------------+\n#  |       \u0412 \u044d\u0442\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442 \u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u0432 \u0432\u0440\u0435\u043c\u0435\u043d\u0438        |\n#  +-----------------------------------------------------------------------------------+\n#\n#  \u041f\u041b\u0415\u0419\u0421\u0425\u041e\u041b\u0414\u0415\u0420\u042b (\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0437\u0430\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u043c\u0438):\n#\n#    \u041c\u043e\u0434\u0443\u043b\u044c\u043d\u044b\u0435 (\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u044b\u0435) \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f:\n#      \u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u044e\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (\u0434\u0430\u043b\u0435\u0435 - \u044e\u043d\u0438\u0442\u0430) \u0431\u0435\u0437 \u0443\u0447\u0451\u0442\u0430 \u0435\u0434\u0438\u043d\u0438\u0446 \u0431\u043e\u043b\u0435\u0435 \u0432\u044b\u0441\u043e\u043a\u043e\u0433\u043e \u0443\u0440\u043e\u0432\u043d\u044f.\n#      \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b: <ticks>, <seconds>, <minutes>, <hours>, <days>, <years>, <decades>\n#      \u041f\u0440\u0438\u043c\u0435\u0440: \u0432 \"1 \u0447\u0430\u0441 45 \u043c\u0438\u043d\u0443\u0442\", <minutes> \u0440\u0430\u0432\u043d\u044f\u0435\u0442\u0441\u044f 45.\n#\n#    \u0410\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435):\n#      \u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u044e\u0442 \u043f\u043e\u043b\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u044e\u043d\u0438\u0442\u0430, \u0431\u0435\u0437 \u0440\u0430\u0437\u0431\u0438\u0432\u043a\u0438 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u043a\u0440\u0443\u043f\u043d\u044b\u0435 \u0443\u0440\u043e\u0432\u043d\u0438.\n#      \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b: <ticks-total>, <seconds-total>, <minutes-total>, <hours-total>, <days-total>, <years-total>\n#      \u041f\u0440\u0438\u043c\u0435\u0440: \u0432 \"1 \u0447\u0430\u0441 45 \u043c\u0438\u043d\u0443\u0442\", <minutes-total> \u0440\u0430\u0432\u043d\u044f\u0435\u0442\u0441\u044f 105.\n#\n#  \u0423\u0421\u041b\u041e\u0412\u041d\u042b\u0415 \u0411\u041b\u041e\u041a\u0418:\n#\n#    <if-\u044e\u043d\u0438\u0442>...</if-\u044e\u043d\u0438\u0442>    ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u044e\u043d\u0438\u0442 \u041d\u0415 = 0\n#    <if-!\u044e\u043d\u0438\u0442>...</if-!\u044e\u043d\u0438\u0442>  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u044e\u043d\u0438\u0442 == 0\n#\n#    \u041f\u0440\u0438\u043c\u0435\u0440: \"<if-hours-total><hours-total>:</if-hours-total><minutes>:<seconds>\"\n#      => \u0447\u0430\u0441\u044b \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0432\u043d\u043e \u0438\u043b\u0438 \u0432\u044b\u0448\u0435 1 \u0447\u0430\u0441\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 1:45:00)\n#\n#  \u041c\u041d\u041e\u0416\u0415\u0421\u0422\u0412\u0415\u041d\u041d\u042b\u0415 \u0427\u0418\u0421\u041b\u0410:\n#\n#    [\u0442\u0435\u043a\u0441\u0442]  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e \u041d\u0415 = 1\n#    {\u0442\u0435\u043a\u0441\u0442}  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e == 1\n#\n#    \u041f\u0440\u0438\u043c\u0435\u0440: \"<minutes> minute[s]\" => 1 minute / 2 minutes\n#\n#    [\u0442\u0435\u043a\u0441\u0442]<n>  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e \u041d\u0415 = n\n#    {\u0442\u0435\u043a\u0441\u0442}<n>  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e == n\n#\n#    \u041f\u0440\u0438\u043c\u0435\u0440: \"<ticks-total> {\u043f\u044f\u0442\u0451\u0440\u043a\u0430}<5>[\u043d\u0435 \u043f\u044f\u0442\u0451\u0440\u043a\u0430]<5>\" => 5 \u043f\u044f\u0442\u0451\u0440\u043a\u0430 / 3 \u043d\u0435 \u043f\u044f\u0442\u0451\u0440\u043a\u0430\n#\n#    [\u0442\u0435\u043a\u0441\u0442]<a-b>  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e \u041d\u0415 \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 a-b\n#    {\u0442\u0435\u043a\u0441\u0442}<a-b>  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0435\u0435 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0447\u0438\u0441\u043b\u043e \u0415\u0421\u0422\u042c \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 a-b\n#\n#    \u041f\u0440\u0438\u043c\u0435\u0440: \"<ticks-total> {\u043c\u0435\u0436\u0434\u0443 2 \u0438 4}<2-4>[\u043d\u0435 \u043c\u0435\u0436\u0434\u0443 2 \u0438 4]<2-4>\" => 3 \u043c\u0435\u0436\u0434\u0443 2 \u0438 4 / 5 \u043d\u0435 \u043c\u0435\u0436\u0434\u0443 2 \u0438 4\n#\n#    \u041c\u043e\u0436\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0442\u0440\u0435\u0443\u0433\u043e\u043b\u044c\u043d\u044b\u0435 \u0441\u043a\u043e\u0431\u043a\u0438 \u0434\u0432\u043e\u0439\u043d\u044b\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043b\u0438\u0448\u044c \u0441 \u0426\u0418\u0424\u0420\u0410\u041c\u0418, \u0430 \u043d\u0435 \u0446\u0435\u043b\u044b\u043c\u0438 \u0427\u0418\u0421\u041b\u0410\u041c\u0418:\n#     => \"{\u0442\u0435\u043a\u0441\u0442}<<a-b>>\"  ...\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0438\u0434\u0443\u0449\u0430\u044f \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0426\u0418\u0424\u0420\u0410 \u0435\u0441\u0442\u044c \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 a-b\n#        <<1-3>> => \u043f\u043e\u0434\u043e\u0439\u0434\u0443\u0442 1-3, 11-13, 21-23 \u0438 \u0442.\u0434.\n#\n#    \u0411\u043b\u043e\u043a\u0438 \u041c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441 \u0434\u0432\u043e\u0439\u043d\u044b\u043c\u0438 \u0438 \u0442\u0440\u043e\u0439\u043d\u044b\u043c\u0438 \u0441\u043a\u043e\u0431\u043a\u0430\u043c\u0438, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u0443 \u043d\u0438\u0445 \u0431\u043e\u043b\u0435\u0435 \u0432\u044b\u0441\u043e\u043a\u0438\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442:\n#     => \"<ticks> {{{\u0442\u0435\u043a\u0441\u0442}<<5>>}}<0-100>\"  ...\u041f\u043e\u043a\u0430\u0436\u0435\u0442 \"\u0442\u0435\u043a\u0441\u0442\" \u043f\u043e\u0441\u043b\u0435 \u0447\u0438\u0441\u0435\u043b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u043d\u0430 \u0446\u0438\u0444\u0440\u0443 5 \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 0-100\n#\n#  \u0413\u041e\u0422\u041e\u0412\u042b\u0415 \u041f\u0420\u0418\u041c\u0415\u0420\u042b (\u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c):\n#\n#    \"2 days, 0 hours, 17 minutes and 1 second\", \"45 minutes and 30 seconds\":\n#\n#      \"<if-days-total><days-total> day[s], <if-!hours><hours> hour[s], </if-!hours></if-days-total>\n#       <if-hours><hours> hour[s], </if-hours><minutes> minute[s] and <seconds> second[s]\"\n#\n#    \"2 days, 17 minutes and 1 second\", \"45 minutes and 30 seconds\":\n#\n#      \"<if-days-total><days-total> day[s], </if-days-total><if-hours><hours> hour[s], </if-hours>\n#       <minutes> minute[s] and <seconds> second[s]\"\n#\n#    \"26:45:30\", \"25:00\", \"00:05\":\n#\n#      \"<if-hours-total><hours-total>:</if-hours-total><minutes>:<seconds>\"\n#\n#    \"85:45\", \"00:15\":\n#\n#      \"<minutes-total>:<seconds>\"\n#\n";
    }
}

