/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect.text;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.effect.text.DrunkTextElement;
import dev.jsinco.brewery.effect.text.DrunkTextRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DrunkTextTransformer {
    public static String transform(String text, DrunkTextRegistry registry, DrunkState drunkState) {
        if (!EventSection.events().blurredSpeech() || drunkState.additionalModifierData().isEmpty()) {
            return text;
        }
        return DrunkTextTransformer.transform(text, registry.getTextTransformers(drunkState.modifiers()));
    }

    public static String transform(String text, List<DrunkTextElement> drunkTextTransformers) {
        ArrayList<DrunkTextElement.TextTransformation> transformations = new ArrayList<DrunkTextElement.TextTransformation>();
        for (DrunkTextElement transformer : drunkTextTransformers) {
            transformations.addAll(transformer.findTransform(text));
        }
        transformations.sort(Comparator.comparing(DrunkTextElement.TextTransformation::from));
        ArrayList<DrunkTextElement.TextTransformation> clashingTextTransforms = new ArrayList<DrunkTextElement.TextTransformation>();
        StringBuilder output = new StringBuilder();
        int lastIndex = 0;
        for (int i = 0; i < transformations.size(); ++i) {
            if (!clashingTextTransforms.isEmpty() && !DrunkTextTransformer.clashesWithTransforms((DrunkTextElement.TextTransformation)transformations.get(i), clashingTextTransforms)) {
                DrunkTextElement.TextTransformation chosenTransform = (DrunkTextElement.TextTransformation)clashingTextTransforms.getLast();
                output.append(text, lastIndex, chosenTransform.from()).append(chosenTransform.replacement());
                lastIndex = chosenTransform.to();
                clashingTextTransforms.clear();
            }
            clashingTextTransforms.add((DrunkTextElement.TextTransformation)transformations.get(i));
        }
        if (!clashingTextTransforms.isEmpty()) {
            DrunkTextElement.TextTransformation chosenTransform = (DrunkTextElement.TextTransformation)clashingTextTransforms.getLast();
            output.append(text, lastIndex, chosenTransform.from()).append(chosenTransform.replacement()).append(text, chosenTransform.to(), text.length());
        } else {
            output.append(text, lastIndex, text.length());
        }
        return output.toString();
    }

    private static boolean clashesWithTransforms(DrunkTextElement.TextTransformation textTransformation, List<DrunkTextElement.TextTransformation> clashingTextTransforms) {
        int minima = clashingTextTransforms.getFirst().from();
        int maxima = clashingTextTransforms.getFirst().to();
        for (DrunkTextElement.TextTransformation transform : clashingTextTransforms) {
            if (minima > transform.from()) {
                minima = transform.from();
            }
            if (maxima >= transform.to()) continue;
            maxima = transform.to();
        }
        return DrunkTextTransformer.inRange(textTransformation.to(), maxima, minima) || DrunkTextTransformer.inRange(textTransformation.from(), maxima, minima);
    }

    private static boolean inRange(int i, int maxima, int minima) {
        return maxima > i && minima <= i;
    }
}

