/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class CauldronSection
extends OkaeriConfig {
    @Comment(value={"Reduce the number of particles that spawn while cauldrons brew.", "This won't affect performance, but it will make the particles less obtrusive."})
    @CustomKey(value="minimal-particles")
    private boolean minimalParticles = false;
    @Comment(value={"What blocks cauldrons must have below them to be able to brew.", "If this list is empty, cauldrons will brew regardless of the block below them.", "Campfires must be lit and lava must be a source block."})
    @CustomKey(value="heat-sources")
    private List<Holder.Material> heatSources = Stream.of("campfire", "soul_campfire", "lava", "fire", "soul_fire", "magma_block").map(Holder.Material::fromMinecraftId).toList();
    @Comment(value={"How many ticks it will take to cook something one minute"})
    @CustomKey(value="cooking-minute-ticks")
    private long cookingMinuteTicks = 1200L;

    @Generated
    public boolean minimalParticles() {
        return this.minimalParticles;
    }

    @Generated
    public List<Holder.Material> heatSources() {
        return this.heatSources;
    }

    @Generated
    public long cookingMinuteTicks() {
        return this.cookingMinuteTicks;
    }
}

