/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure.serializer;

import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.util.Materials;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.NonNull;

public class MaterialsSerializer
implements ObjectSerializer<Materials> {
    @Override
    public boolean supports(@NonNull Class<? super Materials> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Materials.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Materials object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        Materials materials = object;
        Objects.requireNonNull(materials);
        Materials materials2 = materials;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Materials.TagBacked.class, Materials.Singleton.class, Materials.SetBacked.class}, (Object)materials2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Materials.TagBacked tagBacked = (Materials.TagBacked)materials2;
                data.setValue("#" + tagBacked.key().minimalized("minecraft"));
                break;
            }
            case 1: {
                Materials.Singleton singleton = (Materials.Singleton)materials2;
                data.setValue(singleton.backing());
                break;
            }
            case 2: {
                Materials.SetBacked setBacked = (Materials.SetBacked)materials2;
                data.setValueCollection(setBacked.values(), Holder.Material.class);
            }
        }
    }

    @Override
    public Materials deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (!data.isValue()) {
            return new Materials.SetBacked(data.getValueAsSet(Holder.Material.class));
        }
        String value = data.getValue(String.class);
        if (value.startsWith("#")) {
            return new Materials.TagBacked(BreweryKey.parse(value.replaceFirst("^#", ""), "minecraft"));
        }
        return new Materials.Singleton(data.getValue(Holder.Material.class));
    }
}

