/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.command.argument.BiCommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class FlaggedArgumentBuilder {
    private final Set<Flag> flags;
    private final BiCommandContext<List<Flag>> onCommand;
    private final boolean hasMandatoryFirst;

    public FlaggedArgumentBuilder(Set<Flag> flags, BiCommandContext<List<Flag>> onCommand) {
        this.flags = flags;
        this.onCommand = onCommand;
        this.hasMandatoryFirst = flags.stream().anyMatch(flag -> flag.flagProperties.contains((Object)FlagProperty.MANDATORY_FIRST));
    }

    public List<ArgumentBuilder<CommandSourceStack, ?>> build() {
        return this.build(this.flags, 0);
    }

    private List<ArgumentBuilder<CommandSourceStack, ?>> build(Set<Flag> flags, int depth) {
        ArrayList output = new ArrayList();
        List<Flag> flagsToUse = flags.stream().filter(flag -> this.filterFlag((Flag)flag, depth)).toList();
        for (Flag flag2 : flagsToUse) {
            HashSet<Flag> reducedFlags = new HashSet<Flag>(flags);
            reducedFlags.remove(flag2);
            LiteralArgumentBuilder fullFlagArgument = Commands.literal((String)flag2.fullName());
            List<ArgumentBuilder<CommandSourceStack, ?>> flagArguments = this.build(reducedFlags, depth + 1);
            this.stack(flag2.flagArguments(), argument -> {
                argument.executes(this::execute);
                flagArguments.forEach(arg_0 -> ((ArgumentBuilder)argument).then(arg_0));
            }).ifPresentOrElse(arg_0 -> ((ArgumentBuilder)fullFlagArgument).then(arg_0), () -> FlaggedArgumentBuilder.lambda$build$3(flagArguments, (ArgumentBuilder)fullFlagArgument));
            output.add((ArgumentBuilder<CommandSourceStack, ?>)fullFlagArgument);
            if (flag2.shortName() == null) continue;
            LiteralArgumentBuilder shortFlagArgument = Commands.literal((String)flag2.shortName());
            this.stack(flag2.flagArguments(), argument -> {
                argument.executes(this::execute);
                flagArguments.forEach(arg_0 -> ((ArgumentBuilder)argument).then(arg_0));
            }).ifPresentOrElse(arg_0 -> ((ArgumentBuilder)shortFlagArgument).then(arg_0), () -> FlaggedArgumentBuilder.lambda$build$5(flagArguments, (ArgumentBuilder)shortFlagArgument));
            output.add((ArgumentBuilder<CommandSourceStack, ?>)shortFlagArgument);
        }
        return output;
    }

    private boolean filterFlag(Flag flag, int depth) {
        if (depth == 0 && this.hasMandatoryFirst) {
            return flag.flagProperties().contains((Object)FlagProperty.MANDATORY_FIRST);
        }
        return !flag.flagProperties().contains((Object)FlagProperty.ONLY_FIRST);
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String[] arguments = context.getInput().split("\\s+");
        ArrayList flagsList = new ArrayList();
        for (String argument : arguments) {
            this.findFlag(argument).ifPresent(flagsList::add);
        }
        this.onCommand.accept(context, flagsList);
        return 1;
    }

    private Optional<Flag> findFlag(String argument) {
        for (Flag flag : this.flags) {
            if (argument.equals(flag.fullName())) {
                return Optional.of(flag);
            }
            if (!argument.equals(flag.shortName())) continue;
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    private Optional<ArgumentBuilder<CommandSourceStack, ?>> stack(List<Pair<String, ArgumentType<?>>> sequence, Consumer<ArgumentBuilder<CommandSourceStack, ?>> lastArgumentConsumer) {
        ArgumentBuilder argumentBuilder;
        SequencedCollection reversed = sequence.reversed();
        Iterator iterator = reversed.stream().map(argument -> Commands.argument((String)((String)argument.first()), (ArgumentType)((ArgumentType)argument.second()))).iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        ArgumentBuilder lastArgument = argumentBuilder = (ArgumentBuilder)iterator.next();
        lastArgumentConsumer.accept(lastArgument);
        while (iterator.hasNext()) {
            ArgumentBuilder next = (ArgumentBuilder)iterator.next();
            next.then(argumentBuilder);
            argumentBuilder = next;
        }
        return Optional.of(argumentBuilder);
    }

    private static /* synthetic */ void lambda$build$5(List flagArguments, ArgumentBuilder shortFlagArgument) {
        flagArguments.forEach(arg_0 -> ((ArgumentBuilder)shortFlagArgument).then(arg_0));
    }

    private static /* synthetic */ void lambda$build$3(List flagArguments, ArgumentBuilder fullFlagArgument) {
        flagArguments.forEach(arg_0 -> ((ArgumentBuilder)fullFlagArgument).then(arg_0));
    }

    public record Flag(String fullName, @Nullable String shortName, List<Pair<String, ArgumentType<?>>> flagArguments, Set<FlagProperty> flagProperties) {
    }

    public static enum FlagProperty {
        MANDATORY_FIRST,
        ONLY_FIRST;

    }
}

