/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.integration;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.integration.Integration;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.api.ingredient.PluginIngredient;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemIntegration
extends Integration {
    public Optional<ItemStack> createItem(String var1);

    public boolean isIngredient(String var1);

    default public CompletableFuture<Optional<Ingredient>> createIngredient(String id) {
        return this.initialized().handleAsync((ignored1, exception) -> {
            if (exception != null) {
                Logger.logErr("Couldn't create PluginIngredient '" + id + "' for item integration " + this.getId());
                Logger.logErr(exception);
                return Optional.empty();
            }
            if (!this.isIngredient(id)) {
                Logger.logErr("Couldn't create PluginIngredient '" + id + "' for item integration " + this.getId());
                return Optional.empty();
            }
            return Optional.of(new PluginIngredient(new BreweryKey(this.getId(), id), this));
        });
    }

    @Nullable
    public Component displayName(String var1);

    @Nullable
    public String getItemId(ItemStack var1);

    public CompletableFuture<Void> initialized();

    default public Optional<Ingredient> getIngredient(@NotNull ItemStack itemStack) {
        return Optional.ofNullable(this.getItemId(itemStack)).map(id -> new PluginIngredient(new BreweryKey(this.getId(), (String)id), this));
    }
}

