/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryKeyed;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BreweryRegistry<T extends BreweryKeyed> {
    public static final BreweryRegistry<BarrelType> BARREL_TYPE = BreweryRegistry.fromEnums(BarrelType.class);
    public static final BreweryRegistry<CauldronType> CAULDRON_TYPE = BreweryRegistry.fromEnums(CauldronType.class);
    public static final BreweryRegistry<StructureMeta<?>> STRUCTURE_META = BreweryRegistry.fromFields(StructureMeta.class);
    public static final BreweryRegistry<StructureType> STRUCTURE_TYPE = BreweryRegistry.fromFields(StructureType.class);
    public static final BreweryRegistry<NamedDrunkEvent> DRUNK_EVENT = BreweryRegistry.fromJson("/named_drunk_events.json", NamedDrunkEvent.class);
    private final ImmutableMap<BreweryKey, T> backing;

    private BreweryRegistry(Collection<T> values) {
        ImmutableMap.Builder registryBacking = ImmutableMap.builder();
        values.forEach(value -> registryBacking.put((Object)value.key(), value));
        this.backing = registryBacking.build();
    }

    public Collection<T> values() {
        return this.backing.values();
    }

    @Nullable
    public T get(BreweryKey key) {
        return (T)((BreweryKeyed)this.backing.get((Object)key));
    }

    public boolean containsKey(BreweryKey key) {
        return this.backing.containsKey((Object)key);
    }

    private static <E extends Enum<E>> BreweryRegistry<E> fromEnums(Class<E> enumClass) {
        return new BreweryRegistry<Enum>(Arrays.stream((Enum[])enumClass.getEnumConstants()).toList());
    }

    private static <T extends BreweryKeyed> BreweryRegistry<? extends T> fromFields(Class<T> tClass) {
        try {
            ArrayList<BreweryKeyed> tList = new ArrayList<BreweryKeyed>();
            for (Field field : tClass.getDeclaredFields()) {
                Object staticField;
                if (!Modifier.isStatic(field.getModifiers()) || !tClass.isInstance(staticField = field.get(null))) continue;
                tList.add((BreweryKeyed)tClass.cast(staticField));
            }
            return new BreweryRegistry(tList);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T extends BreweryKeyed> BreweryRegistry<T> fromJson(String path, Class<T> tClass) {
        Gson gson = new Gson();
        try (InputStream inputStream = BreweryRegistry.class.getResourceAsStream(path);){
            BreweryRegistry<T> breweryRegistry;
            try (InputStreamReader reader = new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)inputStream, (Object)("InputStream for path '" + path + "' cannot be null")));){
                Type listType = TypeToken.getParameterized(List.class, new Type[]{tClass}).getType();
                List tList = (List)gson.fromJson((Reader)reader, listType);
                breweryRegistry = new BreweryRegistry<T>(tList);
            }
            return breweryRegistry;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from JSON at path: " + path, e);
        }
    }
}

