/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.jsinco.brewery.api.event.EventStepProperty;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface EventStep {
    public Set<EventStepProperty> properties();

    public static class Builder {
        ImmutableSet.Builder<EventStepProperty> propertyBuilder = new ImmutableSet.Builder();

        public Builder addProperty(@NotNull EventStepProperty property) {
            Preconditions.checkNotNull((Object)property);
            this.propertyBuilder.add((Object)property);
            return this;
        }

        public EventStep build() {
            return new EventStepImpl((Set<EventStepProperty>)this.propertyBuilder.build());
        }

        private record EventStepImpl(Set<EventStepProperty> properties) implements EventStep
        {
        }
    }
}

