/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.brew;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Moment;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;

public interface BrewingStep {
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep var1);

    public StepType stepType();

    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep var1);

    public Map<ScoreType, PartialBrewScore> failedScores();

    default public Component infoDisplay(Brew.State state, TagResolver resolver) {
        Brew.State state2 = state;
        Objects.requireNonNull(state2);
        Brew.State state3 = state2;
        int n = 0;
        return Component.translatable((String)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Brew.State.Other.class, Brew.State.Seal.class, Brew.State.Brewing.class}, (Object)state3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Brew.State.Other ignored = (Brew.State.Other)state3;
                yield "tbp.brew.tooltip." + this.stepType().name().toLowerCase(Locale.ROOT);
            }
            case 1 -> {
                Brew.State.Seal ignored = (Brew.State.Seal)state3;
                yield "tbp.brew.tooltip-sealed." + this.stepType().name().toLowerCase(Locale.ROOT);
            }
            case 2 -> {
                Brew.State.Brewing ignored = (Brew.State.Brewing)state3;
                yield "tbp.brew.tooltip-brewing." + this.stepType().name().toLowerCase(Locale.ROOT);
            }
        }), (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)resolver)});
    }

    public static enum StepType {
        COOK,
        DISTILL,
        AGE,
        MIX;

    }

    public static interface Mix
    extends BrewingStep,
    TimedStep,
    IngredientsStep {
        public Mix withIngredients(Map<Ingredient, Integer> var1);

        public Mix withTime(Moment var1);
    }

    public static interface Age
    extends BrewingStep,
    TimedStep {
        public BarrelType barrelType();

        public Age withAge(Moment var1);
    }

    public static interface Distill
    extends BrewingStep {
        public int runs();

        public Distill incrementRuns();
    }

    public static interface Cook
    extends BrewingStep,
    TimedStep,
    IngredientsStep {
        public CauldronType cauldronType();

        public Cook withBrewTime(Moment var1);

        public Cook withIngredients(Map<Ingredient, Integer> var1);
    }

    public static interface IngredientsStep {
        public Map<? extends Ingredient, Integer> ingredients();
    }

    public static interface TimedStep {
        public Moment time();
    }
}

