/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.recipe.ScoreCondition;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ScoreConditions {

    public record IngredientsConditionImpl(Map<Ingredient, ScoreCondition.AmountCondition> conditions) implements ScoreCondition.IngredientsCondition
    {
        @Override
        public boolean matches(@Nullable BrewingStep expected, BrewingStep actual) {
            if (!(actual instanceof BrewingStep.IngredientsStep)) {
                return false;
            }
            BrewingStep.IngredientsStep actualIngredients = (BrewingStep.IngredientsStep)((Object)actual);
            for (Map.Entry<Ingredient, ScoreCondition.AmountCondition> condition : this.conditions.entrySet()) {
                int actualAmount = actualIngredients.ingredients().getOrDefault(condition.getKey(), -1);
                if (!(expected instanceof BrewingStep.IngredientsStep)) {
                    if (condition.getValue() == ScoreCondition.AmountCondition.ANY) continue;
                    return false;
                }
                BrewingStep.IngredientsStep expectedIngredients = (BrewingStep.IngredientsStep)((Object)expected);
                int expectedAmount = expectedIngredients.ingredients().getOrDefault(condition.getKey(), -1);
                if (actualAmount == -1) {
                    return false;
                }
                if (!(expectedAmount == -1 ? condition.getValue() != ScoreCondition.AmountCondition.ANY : !condition.getValue().matches(actualAmount, expectedAmount))) continue;
                return false;
            }
            return true;
        }
    }

    public record SingletonConditionImpl(ScoreCondition.AmountCondition amountCondition, ScoreType type) implements ScoreCondition.SingletonCondition
    {
        @Override
        public boolean matches(@Nullable BrewingStep expected, BrewingStep actual) {
            if (expected != null && expected.getClass() != actual.getClass()) {
                return false;
            }
            return switch (this.type) {
                default -> throw new MatchException(null, null);
                case ScoreType.TIME -> {
                    BrewingStep.TimedStep actualTime;
                    if (actual instanceof BrewingStep.TimedStep && this.amountCondition.matches((actualTime = (BrewingStep.TimedStep)((Object)actual)).time().moment(), expected == null ? -1.0 : (double)((BrewingStep.TimedStep)((Object)expected)).time().moment())) {
                        yield true;
                    }
                    yield false;
                }
                case ScoreType.INGREDIENTS, ScoreType.BARREL_TYPE -> false;
                case ScoreType.DISTILL_AMOUNT -> {
                    if (expected instanceof BrewingStep.Distill) {
                        BrewingStep.Distill actualDistill;
                        BrewingStep.Distill expectedDistill = (BrewingStep.Distill)expected;
                        if (actual instanceof BrewingStep.Distill && this.amountCondition.matches((actualDistill = (BrewingStep.Distill)actual).runs(), expectedDistill.runs())) {
                            yield true;
                        }
                    }
                    yield false;
                }
            };
        }
    }
}

