/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.lib.org.simpleyaml.configuration;

import dev.jsinco.brewery.lib.org.simpleyaml.configuration.Configuration;
import dev.jsinco.brewery.lib.org.simpleyaml.utils.Validate;
import java.util.Objects;

public class ConfigurationWrapper<T extends Configuration> {
    protected final T configuration;
    protected final String path;
    protected final ConfigurationWrapper<T> parent;

    protected ConfigurationWrapper(T configuration, String path, ConfigurationWrapper<T> parent) {
        Validate.notNull(configuration, "configuration cannot be null!");
        this.configuration = configuration;
        this.path = parent == null ? path : parent.childPath(path);
        this.parent = parent;
    }

    public ConfigurationWrapper(T configuration, String path) {
        this(configuration, path, null);
    }

    public ConfigurationWrapper<T> path(String path) {
        return new ConfigurationWrapper<T>(this.configuration, path, this);
    }

    public ConfigurationWrapper<T> set(Object value) {
        return this.set((arg_0, arg_1) -> this.configuration.set(arg_0, arg_1), value);
    }

    public ConfigurationWrapper<T> setChild(String child, Object value) {
        return this.setToChild((arg_0, arg_1) -> this.configuration.set(arg_0, arg_1), child, value);
    }

    public ConfigurationWrapper<T> addDefault(Object value) {
        return this.set((arg_0, arg_1) -> this.configuration.addDefault(arg_0, arg_1), value);
    }

    public ConfigurationWrapper<T> addDefault(String child, Object value) {
        return this.setToChild((arg_0, arg_1) -> this.configuration.addDefault(arg_0, arg_1), child, value);
    }

    public ConfigurationWrapper<T> createSection() {
        return this.apply(arg_0 -> this.configuration.createSection(arg_0));
    }

    public ConfigurationWrapper<T> createSection(String child) {
        return this.applyToChild(arg_0 -> this.configuration.createSection(arg_0), child);
    }

    public String getCurrentPath() {
        return this.path;
    }

    public ConfigurationWrapper<T> parent() {
        int lastSectionIndex;
        if (this.parent == null && this.path != null && (lastSectionIndex = this.path.lastIndexOf(this.configuration.options().pathSeparator())) >= 0) {
            return new ConfigurationWrapper<T>(this.configuration, this.path.substring(0, lastSectionIndex));
        }
        return this.parent;
    }

    protected final String childPath(String child) {
        if (this.path == null) {
            return child;
        }
        return this.path + this.configuration.options().pathSeparator() + child;
    }

    protected ConfigurationWrapper<T> apply(ApplyToPath method) {
        method.apply(this.path);
        return this;
    }

    protected ConfigurationWrapper<T> applyToChild(ApplyToPath method, String path) {
        method.apply(this.childPath(path));
        return this;
    }

    protected ConfigurationWrapper<T> set(SetToPath method, Object value) {
        method.set(this.path, value);
        return this;
    }

    protected ConfigurationWrapper<T> setToChild(SetToPath method, String child, Object value) {
        method.set(this.childPath(child), value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationWrapper that = (ConfigurationWrapper)o;
        return this.configuration == that.configuration && Objects.equals(this.path, that.path) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.path, this.parent);
    }

    @FunctionalInterface
    protected static interface SetToPath {
        public <T> void set(String var1, T var2);
    }

    @FunctionalInterface
    protected static interface ApplyToPath {
        public void apply(String var1);
    }
}

