/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.math.RangeF;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.sound.SoundDefinition;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.kyori.adventure.key.Key;

public class SoundDefinitionSerializer
implements ObjectSerializer<SoundDefinition> {
    private String serializeSoundSetting(SoundDefinition.SoundSetting soundSetting) {
        if (Objects.equals(soundSetting.pitch(), new RangeF(1.0f, 1.0f))) {
            return soundSetting.soundKey().toString();
        }
        if (soundSetting.pitch().min() == soundSetting.pitch().max()) {
            return soundSetting.soundKey().toString() + "/" + String.valueOf(soundSetting.pitch());
        }
        return soundSetting.soundKey().toString() + "/" + soundSetting.pitch().min() + ";" + soundSetting.pitch().max();
    }

    public static SoundDefinition.SoundSetting parseSoundSetting(String string) {
        String[] split = string.split("/");
        if (split.length > 2) {
            throw new IllegalArgumentException("Invalid sound definition");
        }
        Key sound = Key.key((String)split[0]);
        RangeF pitchRange = split.length > 1 ? RangeF.fromString(split[1]) : new RangeF(1.0f, 1.0f);
        Preconditions.checkArgument((pitchRange.min() >= 0.0f ? 1 : 0) != 0, (Object)"Minimum value of range needs to be 0 or larger");
        Preconditions.checkArgument((pitchRange.max() <= 2.0f ? 1 : 0) != 0, (Object)"Maximum value of range needs to be 2 or smaller");
        return new SoundDefinition.SoundSetting(sound, pitchRange);
    }

    @Override
    public boolean supports(@NonNull Class<? super SoundDefinition> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SoundDefinition.class == type;
    }

    @Override
    public void serialize(@NonNull SoundDefinition object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        List<SoundDefinition.SoundSetting> sounds = object.sounds();
        if (sounds.size() == 1) {
            data.setValue(this.serializeSoundSetting(sounds.getFirst()));
            return;
        }
        data.setValue(sounds.stream().map(this::serializeSoundSetting).toList());
    }

    @Override
    public SoundDefinition deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (List.class.isAssignableFrom(generics.getType())) {
            List<String> serialized = data.getValueAsList(String.class);
            if (serialized == null || serialized.isEmpty()) {
                return null;
            }
            return new SoundDefinition(serialized.stream().filter(string -> !string.isBlank()).map(SoundDefinitionSerializer::parseSoundSetting).toList());
        }
        String serialized = data.getValue(String.class);
        if (serialized == null || serialized.isBlank()) {
            return null;
        }
        return new SoundDefinition(List.of(SoundDefinitionSerializer.parseSoundSetting(serialized)));
    }
}

