/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.effect.modifier.ModifierDisplay;
import dev.jsinco.brewery.api.effect.modifier.ModifierExpression;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import lombok.NonNull;

public class ModifierDisplaySerializer
implements ObjectSerializer<ModifierDisplay> {
    @Override
    public boolean supports(@NonNull Class<? super ModifierDisplay> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ModifierDisplay.class == type;
    }

    @Override
    public void serialize(@NonNull ModifierDisplay object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.add("message", object.message());
        data.add("filter", object.filter());
        data.add("display-value", object.value());
        data.add("display-window", (Object)object.displayWindow());
    }

    @Override
    public ModifierDisplay deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String message = data.get("message", String.class);
        ModifierExpression filter = data.get("filter", ModifierExpression.class);
        ModifierExpression value = data.get("display-value", ModifierExpression.class);
        ModifierDisplay.DisplayWindow window = data.get("display-window", ModifierDisplay.DisplayWindow.class);
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"Modifier display requires a filter");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Modifier display requires a display-value");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Modifier display requires a message");
        return new ModifierDisplay(message, filter, value, window == null ? ModifierDisplay.DisplayWindow.ACTION_BAR : window);
    }
}

