/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientGroup;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.ingredient.ScoredIngredient;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import dev.jsinco.brewery.util.FutureUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class IngredientsSection
extends OkaeriConfig {
    @CustomKey(value="ingredient-groups")
    @Comment(value={"To reference an ingredient group in your recipe, use the key", "'#brewery:my_ingredient_group_key' normally as any ingredient.", "You can also define vanilla tags here, for example #leaves"})
    private List<IngredientGroupSection> ingredientGroups = List.of(new IngredientGroupSection("grass", (Component)Component.text((String)"Grass"), List.of("+grass_block", "++fern", "+++short_grass", "+++tall_grass", "++short_dry_grass", "++tall_dry_grass")));
    @Exclude
    private static IngredientsSection instance;
    @Exclude
    private static Map<String, CompletableFuture<Optional<Ingredient>>> validatedIngredients;

    public static IngredientsSection ingredients() {
        return instance;
    }

    public static void load(File dataFolder, OkaeriSerdesPack ... packs) {
        instance = ConfigManager.create(IngredientsSection.class, it -> {
            it.withConfigurer(new YamlSnakeYamlConfigurer(), packs);
            it.withBindFile(new File(dataFolder, "ingredients.yml"));
            it.withRemoveOrphans(true);
            it.saveDefaults();
            it.load(true);
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void validate(IngredientManager<?> ingredientManager, Function<String, List<String>> tagResolver) {
        HashSet<String> keys = new HashSet<String>();
        // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull @NotNull ImmutableMap.Builder ingredientsFutures = new ImmutableMap.Builder();
        for (IngredientGroupSection ingredientGroup : instance.ingredientGroups()) {
            String key = ingredientGroup.key;
            Preconditions.checkArgument((!keys.contains(key) ? 1 : 0) != 0, (Object)("Can't have two ingredient groups with the same key (ingredients.yml): " + key));
            keys.add(key);
            ingredientsFutures.put((Object)("#brewery:" + key), ingredientGroup.create(ingredientManager, tagResolver));
        }
        validatedIngredients = ingredientsFutures.build();
    }

    public CompletableFuture<Optional<Ingredient>> getIngredient(String key) {
        return Optional.ofNullable(validatedIngredients.get(key)).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Generated
    public List<IngredientGroupSection> ingredientGroups() {
        return this.ingredientGroups;
    }

    public static class IngredientGroupSection
    extends OkaeriConfig {
        private String key;
        @CustomKey(value="display-name")
        private Component displayName;
        private List<String> materials;
        @Exclude
        private static final Pattern INGREDIENT_GROUP_PATTERN = Pattern.compile("^\\+{0,3}#brewery:");

        public IngredientGroupSection() {
        }

        public IngredientGroupSection(String key, Component displayName, List<String> materials) {
            this.key = key;
            this.displayName = displayName;
            this.materials = materials;
        }

        private CompletableFuture<Optional<Ingredient>> create(IngredientManager<?> ingredientManager, Function<String, List<String>> tagResolver) {
            ArrayList group = new ArrayList();
            for (String material : this.materials) {
                List<String> strings;
                if (INGREDIENT_GROUP_PATTERN.matcher(material).find()) {
                    Logger.logErr("Ingredient groups are not allowed to reference other groups!");
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                String withoutScores = material.replaceAll("^\\+{1,3}", "");
                if (withoutScores.startsWith("#")) {
                    strings = tagResolver.apply(withoutScores.replaceFirst("#", ""));
                    if (strings == null) {
                        Logger.logErr("Invalid item tag: " + withoutScores);
                        return CompletableFuture.completedFuture(Optional.empty());
                    }
                } else {
                    strings = List.of(withoutScores);
                }
                strings.forEach(tagMaterial -> group.add(ingredientManager.getIngredient((String)tagMaterial).thenApplyAsync(ingredient -> {
                    Optional<Ingredient> ingredientOptional = ingredient.map(ingredient0 -> this.parseScore((Ingredient)ingredient0, material));
                    if (ingredientOptional.isEmpty()) {
                        Logger.logErr("Unknown ingredient: " + tagMaterial);
                    }
                    return ingredientOptional;
                })));
            }
            return FutureUtil.mergeFutures(group).thenApplyAsync(ingredients -> {
                if (ingredients.stream().anyMatch(Optional::isEmpty)) {
                    return Optional.empty();
                }
                return Optional.of(new IngredientGroup("#brewery:" + this.key, this.displayName, ingredients.stream().map(Optional::get).toList()));
            });
        }

        private Ingredient parseScore(Ingredient ingredient, String ingredientString) {
            if (ingredientString.startsWith("+++")) {
                return new ScoredIngredient(ingredient, 1.0);
            }
            if (ingredientString.startsWith("++")) {
                return new ScoredIngredient(ingredient, 0.7);
            }
            if (ingredientString.startsWith("+")) {
                return new ScoredIngredient(ingredient, 0.3);
            }
            return ingredient;
        }

        @Generated
        public String key() {
            return this.key;
        }
    }
}

