/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffect;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class RecipeEffectPersistentDataType
implements PersistentDataType<String, RecipeEffect> {
    private static final RecipeEffectPersistentDataType SINGLETON_INSTANCE = new RecipeEffectPersistentDataType();
    public static final ListPersistentDataType<String, RecipeEffect> INSTANCE = ListPersistentDataType.LIST.listTypeFrom((PersistentDataType)SINGLETON_INSTANCE);

    @NotNull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @NotNull
    public Class<RecipeEffect> getComplexType() {
        return RecipeEffect.class;
    }

    @NotNull
    public String toPrimitive(@NotNull RecipeEffect complex, @NotNull PersistentDataAdapterContext context) {
        return complex.type().key().asString() + "/" + complex.durationRange().asString() + "/" + complex.amplifierRange().asString();
    }

    @NotNull
    public RecipeEffect fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
        String[] split = primitive.split("/");
        PotionEffectType effectType = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.fromString((String)split[0]));
        Preconditions.checkArgument((effectType != null ? 1 : 0) != 0, (Object)"Effect type can not be null");
        Interval duration = Interval.parseString(split[1]);
        Interval amplifier = Interval.parseString(split[2]);
        return new RecipeEffect(effectType, duration, amplifier);
    }
}

