/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.placeholder;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderApiExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "tbp";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)",", TheBrewingProject.getInstance().getPluginMeta().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return TheBrewingProject.getInstance().getPluginMeta().getVersion();
    }

    public String onRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        return this.readPlayer(player, params);
    }

    public String onPlaceholderRequest(@Nullable Player player, @NotNull String params) {
        return this.readPlayer((OfflinePlayer)player, params);
    }

    private String readPlayer(OfflinePlayer player, String params) {
        if (player == null) {
            return null;
        }
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        DrunkState drunkState = drunksManager.getDrunkState(player.getUniqueId());
        if (drunkState == null) {
            drunkState = new DrunkStateImpl(TheBrewingProject.getInstance().getTime(), -1L, DrunkenModifierSection.modifiers().drunkenModifiers().stream().collect(Collectors.toUnmodifiableMap(modifier -> modifier, DrunkenModifier::minValue)));
        }
        for (DrunkenModifier modifier2 : DrunkenModifierSection.modifiers().drunkenModifiers()) {
            if (!params.equals(modifier2.name())) continue;
            return String.valueOf(drunkState.modifierValue(modifier2));
        }
        if (params.equals("next_event")) {
            Pair<DrunkEvent, Long> event = drunksManager.getPlannedEvent(player.getUniqueId());
            if (event == null) {
                return PlainTextComponentSerializer.plainText().serialize((Component)Component.translatable((String)"tbp.events.nothing-planned"));
            }
            return PlainTextComponentSerializer.plainText().serialize(event.first().displayName());
        }
        return null;
    }
}

