/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.chest_shop;

import com.ghostchu.quickshop.api.event.general.ShopItemMatchEvent;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.ScoredIngredient;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.ChestShopIntegration;
import dev.jsinco.brewery.bukkit.ingredient.BreweryIngredient;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.util.ClassUtil;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class QuickShopHikariIntegration
implements ChestShopIntegration,
Listener {
    @Override
    public String getId() {
        return "quick_shop_hikari";
    }

    @Override
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TheBrewingProject.getInstance());
    }

    @Override
    public boolean isEnabled() {
        return ClassUtil.exists("com.ghostchu.quickshop.api.event.general.ShopItemMatchEvent");
    }

    @EventHandler(ignoreCancelled=true)
    public void onShopItemMatch(ShopItemMatchEvent event) {
        event.matches(this.matches(event.original(), event.comparison()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matches(ItemStack originalItem, ItemStack comparisonItem) {
        Ingredient original = BukkitIngredientManager.INSTANCE.getIngredient(originalItem);
        double originalScore = 1.0;
        if (original instanceof ScoredIngredient) {
            ScoredIngredient scoredIngredient = (ScoredIngredient)original;
            try {
                double d;
                double score1;
                Ingredient ingredient;
                Ingredient baseIngredient = ingredient = scoredIngredient.baseIngredient();
                originalScore = score1 = (d = scoredIngredient.score());
                original = baseIngredient;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(original instanceof BreweryIngredient)) return false;
        BreweryIngredient origininalBreweryIngredient = (BreweryIngredient)original;
        Ingredient comparison = BukkitIngredientManager.INSTANCE.getIngredient(comparisonItem);
        double comparisonScore = 1.0;
        if (comparison instanceof ScoredIngredient) {
            ScoredIngredient scoredIngredient = (ScoredIngredient)comparison;
            {
                double d;
                double score1;
                Ingredient ingredient;
                Ingredient baseIngredient = ingredient = scoredIngredient.baseIngredient();
                comparisonScore = score1 = (d = scoredIngredient.score());
                comparison = baseIngredient;
            }
        }
        if (!(comparison instanceof BreweryIngredient)) return false;
        BreweryIngredient comparisonBreweryIngredient = (BreweryIngredient)comparison;
        if (!origininalBreweryIngredient.equals(comparisonBreweryIngredient)) return false;
        if (!(comparisonScore > originalScore)) return false;
        return true;
    }
}

