/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.event;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class LegacyPlayerJoinListener
implements Listener {
    private static final Random RANDOM = new Random();

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        UUID playerUuid = event.getPlayer().getUniqueId();
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        DrunkState drunkState = drunksManager.getDrunkState(playerUuid);
        String playerName = event.getPlayer().getName();
        if (drunksManager.isPassedOut(playerUuid)) {
            String kickEventMessage = EventSection.events().kickEvent().kickEventMessage();
            TagResolver tagResolver = BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)event.getPlayer());
            Component playerKickMessage = kickEventMessage == null ? Component.translatable((String)"tbp.events.default-kick-event-message", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)tagResolver)}) : MessageUtil.miniMessage(kickEventMessage, tagResolver);
            event.kickMessage(GlobalTranslator.render((Component)playerKickMessage, (Locale)Config.config().language()));
            event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            return;
        }
        EventSection.DrunkenJoinEvent joinEvent = EventSection.events().drunkenJoinDeny();
        if (joinEvent.enabled() && drunkState != null && joinEvent.probability().evaluate(DrunkStateImpl.compileVariables(drunkState.modifiers(), null, 0.0)).probability() > RANDOM.nextDouble(100.0)) {
            event.kickMessage(GlobalTranslator.render((Component)Component.translatable((String)"tbp.events.drunken-join-deny-message", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)Placeholder.unparsed((String)"player_name", (String)(playerName == null ? "" : playerName)))}), (Locale)Config.config().language()));
            event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
        }
    }
}

