/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.barrel;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.structure.MultiblockStructure;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.brew.BarrelBrewDataType;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.brew.BukkitBarrelBrewDataType;
import dev.jsinco.brewery.bukkit.breweries.BrewInventory;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrel;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.SqlStatements;
import dev.jsinco.brewery.database.sql.SqlStoredData;
import dev.jsinco.brewery.util.DecoderEncoder;
import dev.jsinco.brewery.util.FutureUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.joml.Matrix3d;

public class BukkitBarrelDataType
implements SqlStoredData.Findable<BukkitBarrel, UUID>,
SqlStoredData.Removable<BukkitBarrel>,
SqlStoredData.Insertable<BukkitBarrel> {
    public static final BukkitBarrelDataType INSTANCE = new BukkitBarrelDataType();
    private final SqlStatements statements = new SqlStatements("/database/generic/barrels");

    @Override
    public void insert(BukkitBarrel value, Connection connection) throws PersistenceException {
        MultiblockStructure placedStructure = value.getStructure();
        BreweryStructure structure = ((PlacedBreweryStructure)placedStructure).getStructure();
        Location origin = ((PlacedBreweryStructure)placedStructure).getWorldOrigin();
        UUID worldUuid = value.getWorld().getUID();
        Location signLocation = value.getUniqueLocation();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.INSERT));){
            preparedStatement.setInt(1, origin.getBlockX());
            preparedStatement.setInt(2, origin.getBlockY());
            preparedStatement.setInt(3, origin.getBlockZ());
            preparedStatement.setInt(4, signLocation.getBlockX());
            preparedStatement.setInt(5, signLocation.getBlockY());
            preparedStatement.setInt(6, signLocation.getBlockZ());
            preparedStatement.setBytes(7, DecoderEncoder.asBytes(worldUuid));
            preparedStatement.setString(8, DecoderEncoder.serializeTransformation(((PlacedBreweryStructure)placedStructure).getTransformation()));
            preparedStatement.setString(9, structure.getName());
            preparedStatement.setString(10, value.getType().key().toString());
            preparedStatement.setInt(11, value.getSize());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        for (Pair<Brew, Integer> brew : value.getBrews()) {
            BarrelBrewDataType.BarrelContext context = new BarrelBrewDataType.BarrelContext(signLocation.getBlockX(), signLocation.getBlockY(), signLocation.getBlockZ(), brew.second(), signLocation.getWorld().getUID());
            TheBrewingProject.getInstance().getDatabase().insertValue(BukkitBarrelBrewDataType.INSTANCE, new Pair<Brew, BarrelBrewDataType.BarrelContext>(brew.first(), context));
        }
    }

    @Override
    public void remove(BukkitBarrel toRemove, Connection connection) throws PersistenceException {
        UUID worldUuid = toRemove.getWorld().getUID();
        Location signLocation = toRemove.getUniqueLocation();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.DELETE));){
            preparedStatement.setInt(1, signLocation.getBlockX());
            preparedStatement.setInt(2, signLocation.getBlockY());
            preparedStatement.setInt(3, signLocation.getBlockZ());
            preparedStatement.setBytes(4, DecoderEncoder.asBytes(worldUuid));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<BukkitBarrel> find(UUID world, Connection connection) throws PersistenceException {
        ArrayList<BukkitBarrel> output = new ArrayList<BukkitBarrel>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.FIND));){
            preparedStatement.setBytes(1, DecoderEncoder.asBytes(world));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Location worldOrigin = new Location(Bukkit.getWorld((UUID)world), (double)resultSet.getInt("origin_x"), (double)resultSet.getInt("origin_y"), (double)resultSet.getInt("origin_z"));
                Location uniqueLocation = new Location(Bukkit.getWorld((UUID)world), (double)resultSet.getInt("unique_x"), (double)resultSet.getInt("unique_y"), (double)resultSet.getInt("unique_z"));
                Matrix3d transform = DecoderEncoder.deserializeTransformation(resultSet.getString("transformation"));
                String format = resultSet.getString("format");
                BarrelType type = BreweryRegistry.BARREL_TYPE.get(BreweryKey.parse(resultSet.getString("barrel_type")));
                if (type == null) {
                    Logger.logErr("Unknown barrel type '" + resultSet.getString("barrel_type") + "' for structure at: " + String.valueOf(uniqueLocation));
                    continue;
                }
                int size = resultSet.getInt("size");
                Optional<BreweryStructure> breweryStructureOptional = TheBrewingProject.getInstance().getStructureRegistry().getStructure(format);
                if (breweryStructureOptional.isEmpty()) {
                    Logger.logErr("Could not find format '" + format + "' skipping barrel at: " + String.valueOf(uniqueLocation));
                    continue;
                }
                PlacedBreweryStructure<BukkitBarrel> structure = new PlacedBreweryStructure<BukkitBarrel>(breweryStructureOptional.get(), transform, worldOrigin);
                BukkitBarrel barrel = new BukkitBarrel(uniqueLocation, structure, size, type);
                structure.setHolder(barrel);
                output.add(barrel);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        for (BukkitBarrel barrel : output) {
            BrewInventory barrelInventory = barrel.getInventory();
            ((CompletableFuture)FutureUtil.mergeFutures(BukkitBarrelBrewDataType.INSTANCE.find(BukkitAdapter.toBreweryLocation(barrel.getUniqueLocation()), connection)).thenAcceptAsync(brews -> brews.forEach(pair -> barrelInventory.set((Brew)pair.first(), (Integer)pair.second())))).join();
        }
        return output;
    }
}

