/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries;

import com.google.gson.JsonParser;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.bukkit.breweries.BukkitCauldron;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.SqlStatements;
import dev.jsinco.brewery.database.sql.SqlStoredData;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class BukkitCauldronDataType
implements SqlStoredData.Findable<CompletableFuture<BukkitCauldron>, UUID>,
SqlStoredData.Insertable<BukkitCauldron>,
SqlStoredData.Updateable<BukkitCauldron>,
SqlStoredData.Removable<BukkitCauldron> {
    public static final BukkitCauldronDataType INSTANCE = new BukkitCauldronDataType();
    private final SqlStatements statements = new SqlStatements("/database/generic/cauldrons");

    @Override
    public void insert(BukkitCauldron value, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.INSERT));){
            BreweryLocation location = value.position();
            preparedStatement.setInt(1, location.x());
            preparedStatement.setInt(2, location.y());
            preparedStatement.setInt(3, location.z());
            preparedStatement.setBytes(4, DecoderEncoder.asBytes(location.worldUuid()));
            preparedStatement.setString(5, BrewImpl.SERIALIZER.serialize(value.getBrew()).toString());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void update(BukkitCauldron newValue, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.UPDATE));){
            BreweryLocation location = newValue.position();
            preparedStatement.setString(1, BrewImpl.SERIALIZER.serialize(newValue.getBrew()).toString());
            preparedStatement.setInt(2, location.x());
            preparedStatement.setInt(3, location.y());
            preparedStatement.setInt(4, location.z());
            preparedStatement.setBytes(5, DecoderEncoder.asBytes(location.worldUuid()));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void remove(BukkitCauldron toRemove, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.DELETE));){
            BreweryLocation location = toRemove.position();
            preparedStatement.setInt(1, location.x());
            preparedStatement.setInt(2, location.y());
            preparedStatement.setInt(3, location.z());
            preparedStatement.setBytes(4, DecoderEncoder.asBytes(location.worldUuid()));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<CompletableFuture<BukkitCauldron>> find(UUID worldUuid, Connection connection) throws PersistenceException {
        ArrayList<CompletableFuture<BukkitCauldron>> arrayList;
        block9: {
            PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.FIND));
            try {
                preparedStatement.setBytes(1, DecoderEncoder.asBytes(worldUuid));
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<CompletableFuture<BukkitCauldron>> cauldrons = new ArrayList<CompletableFuture<BukkitCauldron>>();
                while (resultSet.next()) {
                    int x = resultSet.getInt("cauldron_x");
                    int y = resultSet.getInt("cauldron_y");
                    int z = resultSet.getInt("cauldron_z");
                    CompletableFuture<Brew> brewFuture = BrewImpl.SERIALIZER.deserialize(JsonParser.parseString(resultSet.getString("brew")).getAsJsonArray(), BukkitIngredientManager.INSTANCE);
                    cauldrons.add((CompletableFuture<BukkitCauldron>)brewFuture.thenApplyAsync(brew -> new BukkitCauldron((Brew)brew, new BreweryLocation(x, y, z, worldUuid))));
                }
                arrayList = cauldrons;
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

