/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.api.moment.PassedMoment;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BrewingStepPdcType
implements PersistentDataType<byte[], BrewingStep> {
    private static final byte[] MAGIC = new byte[]{66, 82, 87, 49};
    private static final int GCM_TAG_BITS = 128;
    private static final int VERSION = 1;
    private final boolean useCipher;

    public BrewingStepPdcType(boolean useCipher) {
        this.useCipher = useCipher;
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<BrewingStep> getComplexType() {
        return BrewingStep.class;
    }

    @NotNull
    public byte[] toPrimitive(@NotNull BrewingStep complex, @NotNull PersistentDataAdapterContext context) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream headerOut = new DataOutputStream(out);
            if (!this.useCipher || !Config.config().encryptSensitiveData()) {
                headerOut.write(MAGIC);
                headerOut.writeByte(1);
                headerOut.writeByte(0);
                try (DataOutputStream dos = new DataOutputStream(out);){
                    this.writePayload(complex, dos);
                }
                return out.toByteArray();
            }
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            headerOut.write(MAGIC);
            headerOut.writeByte(1);
            headerOut.writeByte(iv.length);
            headerOut.write(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)Config.config().encryptionKey(), new GCMParameterSpec(128, iv));
            try (CipherOutputStream cos = new CipherOutputStream(out, cipher);
                 DataOutputStream dos = new DataOutputStream(cos);){
                this.writePayload(complex, dos);
            }
            return out.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void writePayload(@NotNull BrewingStep complex, @NotNull DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(complex.stepType().name());
        BrewingStep brewingStep = complex;
        Objects.requireNonNull(brewingStep);
        BrewingStep brewingStep2 = brewingStep;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Age.class, BrewingStep.Cook.class, BrewingStep.Distill.class, BrewingStep.Mix.class}, (Object)brewingStep2, n)) {
            case 0: {
                BrewingStep.Age age = (BrewingStep.Age)brewingStep2;
                this.encodeMoment(age.time(), dataOutputStream);
                dataOutputStream.writeUTF(age.barrelType().key().toString());
                break;
            }
            case 1: {
                BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep2;
                this.encodeMoment(cook.time(), dataOutputStream);
                this.encodeIngredients(cook.ingredients(), dataOutputStream);
                dataOutputStream.writeUTF(cook.cauldronType().key().toString());
                break;
            }
            case 2: {
                BrewingStep.Distill distill = (BrewingStep.Distill)brewingStep2;
                dataOutputStream.writeInt(distill.runs());
                break;
            }
            case 3: {
                BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep2;
                this.encodeMoment(mix.time(), dataOutputStream);
                this.encodeIngredients(mix.ingredients(), dataOutputStream);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(complex));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public BrewingStep fromPrimitive(@NotNull byte[] primitive, @NotNull PersistentDataAdapterContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteArrayInputStream inDup(byte[] all, int offset) {
        return new ByteArrayInputStream(all, offset, all.length - offset);
    }

    private BrewingStep readPayload(@NotNull DataInputStream dataInputStream) throws IOException {
        BrewingStep.StepType stepType = BrewingStep.StepType.valueOf(dataInputStream.readUTF());
        return switch (stepType) {
            default -> throw new MatchException(null, null);
            case BrewingStep.StepType.COOK -> new CookStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream), BreweryRegistry.CAULDRON_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
            case BrewingStep.StepType.DISTILL -> new DistillStepImpl(dataInputStream.readInt());
            case BrewingStep.StepType.AGE -> new AgeStepImpl(this.decodeMoment(dataInputStream), BreweryRegistry.BARREL_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
            case BrewingStep.StepType.MIX -> new MixStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream));
        };
    }

    private BrewingStep readLegacyDES(byte[] primitive) {
        try {
            return this.attemptDecryptDES(primitive, Config.config().encryptionKey());
        }
        catch (Exception e) {
            Exception lastException = e;
            for (SecretKey key : Config.config().previousEncryptionKeys()) {
                try {
                    return this.attemptDecryptDES(primitive, key);
                }
                catch (Exception e2) {
                    lastException = e2;
                }
            }
            throw new RuntimeException("[DES] Decryption failed after trying all known keys", lastException);
        }
    }

    /*
     * Exception decompiling
     */
    private BrewingStep attemptDecryptDES(byte[] primitive, SecretKey key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void encodeMoment(Moment moment, DataOutputStream dataOutputStream) throws IOException {
        long stop;
        long start;
        if (!(moment instanceof Interval)) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeLong(moment.moment());
            return;
        }
        Interval interval = (Interval)moment;
        try {
            long l;
            start = l = interval.start();
            stop = l = interval.stop();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeLong(start);
        dataOutputStream.writeLong(stop);
    }

    private Moment decodeMoment(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readBoolean()) {
            return new PassedMoment(dataInputStream.readLong());
        }
        return new Interval(dataInputStream.readLong(), dataInputStream.readLong());
    }

    public void encodeIngredients(@NotNull Map<? extends Ingredient, Integer> ingredients, OutputStream outputStream) {
        byte[][] bytesArray = (byte[][])ingredients.entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).getKey() + "/" + String.valueOf(entry.getValue())).map(string -> string.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        try {
            DecoderEncoder.encode(bytesArray, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Map<? extends Ingredient, Integer> decodeIngredients(InputStream inputStream) {
        byte[][] bytesArray;
        HashMap ingredients = new HashMap();
        try {
            bytesArray = DecoderEncoder.decode(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Arrays.stream(bytesArray).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(BukkitIngredientManager.INSTANCE::getIngredientWithAmount).forEach(ingredientAmountPair -> IngredientManager.insertIngredientIntoMap(ingredients, (Pair)ingredientAmountPair.join()));
        return ingredients;
    }

    private Cipher getLegacyDESCipher(int operationMode, SecretKey key) {
        try {
            NullCipher cipher = Config.config().encryptSensitiveData() && this.useCipher ? Cipher.getInstance("DES") : new NullCipher();
            cipher.init(operationMode, key);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

