/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml;

import dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.KeyTree;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.YamlCommentMapper;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.YamlCommentParser;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.format.YamlCommentFormatterConfiguration;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlConfigurationOptions;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.comments.CommentLine;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.comments.CommentType;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.CollectionNode;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.MappingNode;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Node;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.ScalarNode;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.SequenceNode;
import dev.jsinco.brewery.lib.org.simpleyaml.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SnakeYamlCommentMapper
extends YamlCommentMapper {
    protected KeyTree.Node currentNode;
    protected String sideCommentPrefix;
    protected boolean headerParsed = false;

    protected SnakeYamlCommentMapper(YamlConfigurationOptions options) {
        super(options);
        this.setCommentPrefix(options);
    }

    protected void setCommentPrefix(YamlConfigurationOptions options) {
        YamlCommentFormatterConfiguration sideFormatterConfiguration = options.commentFormatter().formatterConfiguration(dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.CommentType.SIDE);
        this.sideCommentPrefix = sideFormatterConfiguration.prefixFirst("#");
        if (this.sideCommentPrefix.endsWith(" ")) {
            this.sideCommentPrefix = this.sideCommentPrefix.substring(0, this.sideCommentPrefix.length() - 1);
        }
    }

    protected KeyTree.Node track(KeyTree.Node parent, String name, Node key, Node value) {
        int indent = key.getStartMark().getColumn();
        KeyTree.Node commentNode = this.track(parent, indent, name);
        this.trackBlockComment(commentNode, key.getBlockComments());
        this.trackSideComment(commentNode, this.getSideCommentNode(key, value).getInLineComments());
        if (value instanceof SequenceNode) {
            commentNode.isList(((SequenceNode)value).getValue().size());
        }
        return commentNode;
    }

    protected KeyTree.Node trackElement(KeyTree.Node parent, String name, Node key, int elementIndex) {
        KeyTree.Node commentNode = this.track(parent, name, key, null);
        if (elementIndex >= 0) {
            commentNode.setElementIndex(elementIndex);
        }
        return commentNode;
    }

    protected KeyTree.Node track(KeyTree.Node parent, int indent, String key) {
        if (parent == null) {
            parent = this.keyTree.findParent(indent);
        }
        this.currentNode = parent.add(indent, key);
        return this.currentNode;
    }

    protected void trackBlockComment(KeyTree.Node node, List<CommentLine> comments) {
        String indent;
        String commentPrefix;
        String blockComment;
        if (node != null && comments != null && !comments.isEmpty() && (blockComment = this.getComment(comments, commentPrefix = (indent = StringUtils.indentation(node.getIndentation())) + "#", commentPrefix)) != null) {
            if (!this.headerParsed) {
                blockComment = YamlCommentParser.removeHeader(blockComment, this.options());
                this.headerParsed = true;
            }
            this.setRawComment(node, blockComment, dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.CommentType.BLOCK);
        }
    }

    protected void trackSideComment(KeyTree.Node node, List<CommentLine> comments) {
        if (node != null && comments != null && !comments.isEmpty()) {
            String sideComment;
            String multilineCommentPrefix = null;
            if (comments.size() > 1) {
                String indent = StringUtils.indentation(node.getIndentation());
                multilineCommentPrefix = indent + "#";
            }
            if ((sideComment = this.getComment(comments, this.sideCommentPrefix, multilineCommentPrefix)) != null) {
                this.setRawComment(node, sideComment, dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.CommentType.SIDE);
            }
        }
    }

    protected void trackFooter(MappingNode node) {
        List<CommentLine> comments;
        if (node != null && (comments = node.getEndComments()) != null && !comments.isEmpty()) {
            KeyTree.Node footerNode;
            String commentPrefix = "#";
            String footerComment = this.getComment(comments, "#", "#");
            if (footerComment != null && (footerNode = this.track(this.getKeyTree().getRoot(), 0, null)) != null) {
                footerNode.setComment(footerComment);
            }
        }
    }

    protected String getComment(List<CommentLine> commentLines, String firstCommentPrefix, String multilineCommentPrefix) {
        StringBuilder commentBuilder = new StringBuilder();
        Iterator<CommentLine> it = commentLines.iterator();
        boolean hasNext = it.hasNext();
        if (hasNext) {
            CommentLine commentLine = it.next();
            hasNext = it.hasNext();
            boolean last = !hasNext;
            this.appendLine(commentBuilder, firstCommentPrefix, commentLine, last);
            while (hasNext) {
                commentLine = it.next();
                hasNext = it.hasNext();
                last = !hasNext;
                this.appendLine(commentBuilder, multilineCommentPrefix, commentLine, last);
            }
        }
        return commentBuilder.toString();
    }

    protected void appendLine(StringBuilder commentBuilder, String commentPrefix, CommentLine commentLine, boolean last) {
        if (commentLine.getCommentType() != CommentType.BLANK_LINE) {
            commentBuilder.append(commentPrefix).append(commentLine.getValue());
        }
        if (!last) {
            commentBuilder.append('\n');
        }
    }

    protected List<CommentLine> getCommentLines(String comment, CommentType commentType) {
        if (comment == null) {
            return null;
        }
        ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>();
        String[] lines = StringUtils.lines(comment, false);
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtils.stripIndentation(lines[i]);
            boolean isBlank = line.isEmpty();
            if (line.startsWith("#")) {
                line = line.substring(1);
            } else if (isBlank) {
                if (i == 0 && commentType == CommentType.IN_LINE) continue;
                line = "\n";
            }
            CommentType lineCommentType = commentType;
            if (isBlank) {
                lineCommentType = CommentType.BLANK_LINE;
            } else if (i > 0 && commentType == CommentType.IN_LINE) {
                lineCommentType = CommentType.BLOCK;
            }
            commentLines.add(new CommentLine(null, null, line, lineCommentType));
        }
        return commentLines;
    }

    protected void setComments(KeyTree.Node node, Node key, Node value) {
        if (node != null) {
            key.setBlockComments(this.getCommentLines(node.getComment(), CommentType.BLOCK));
            this.getSideCommentNode(key, value).setInLineComments(this.getCommentLines(node.getSideComment(), CommentType.IN_LINE));
        }
    }

    protected void setFooter(MappingNode node) {
        KeyTree.Node footerNode;
        if (node != null && (footerNode = this.getNode(null)) != null) {
            node.setEndComments(this.getCommentLines(footerNode.getComment(), CommentType.BLOCK));
        }
    }

    protected Node getSideCommentNode(Node key, Node value) {
        Node sideCommentNode = key;
        if (value instanceof ScalarNode) {
            DumperOptions.ScalarStyle scalarStyle = ((ScalarNode)value).getScalarStyle();
            if (scalarStyle != DumperOptions.ScalarStyle.LITERAL && scalarStyle != DumperOptions.ScalarStyle.FOLDED) {
                sideCommentNode = value;
            }
        } else if (value != null && !(value instanceof CollectionNode)) {
            sideCommentNode = value;
        }
        return sideCommentNode;
    }

    protected void clearCurrentNodeIfNoComments() {
        super.clearNodeIfNoComments(this.currentNode);
        this.currentNode = null;
    }

    @Override
    protected KeyTree.Node getPriorityNode(String path) {
        return super.getPriorityNode(path);
    }
}

