/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.format;

import dev.jsinco.brewery.format.TimeFormat;
import dev.jsinco.brewery.format.TimeFormatHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class TimeFormatRegistry {
    private static final Map<TimeFormat, String> timeFormats = new EnumMap<TimeFormat, String>(TimeFormat.class);

    public void sync(File externalFile) throws IOException {
        InputStream internalDefaultsStream = this.getClass().getClassLoader().getResourceAsStream("locale/" + externalFile.getName());
        if (internalDefaultsStream == null) {
            return;
        }
        Properties internal = TimeFormatRegistry.loadProperties(internalDefaultsStream);
        this.sync(externalFile, internal);
    }

    public void sync(File externalFile, Properties internalDefaults) throws IOException {
        Objects.requireNonNull(internalDefaults, "internalDefaults");
        Objects.requireNonNull(externalFile, "externalFile");
        Properties external = TimeFormatRegistry.loadExternalIfPresent(externalFile);
        Properties merged = new Properties();
        for (String key : internalDefaults.stringPropertyNames()) {
            String val = external.getProperty(key, internalDefaults.getProperty(key));
            merged.setProperty(key, val);
        }
        TimeFormatRegistry.writeExternal(externalFile, merged);
    }

    public void load(File externalFile) throws IOException {
        InputStream internalDefaultsStream = this.getClass().getClassLoader().getResourceAsStream("locale/" + externalFile.getName());
        Properties internal = TimeFormatRegistry.loadProperties(internalDefaultsStream);
        this.load(externalFile, internal);
    }

    public void load(File externalFile, Properties internalDefaults) throws IOException {
        Objects.requireNonNull(externalFile, "externalFile");
        Properties external = TimeFormatRegistry.loadExternalIfPresent(externalFile);
        timeFormats.clear();
        for (TimeFormat tf : TimeFormat.values()) {
            String key = tf.getKey();
            String value = TimeFormatRegistry.firstNonEmpty(external.getProperty(key), internalDefaults != null ? internalDefaults.getProperty(key) : null, key);
            timeFormats.put(tf, value);
        }
    }

    public void clear() {
        timeFormats.clear();
    }

    public static String get(TimeFormat format) {
        return timeFormats.getOrDefault((Object)format, format.getKey());
    }

    private static String firstNonEmpty(String a, String b, String c) {
        if (a != null && !a.isEmpty()) {
            return a;
        }
        if (b != null && !b.isEmpty()) {
            return b;
        }
        return c;
    }

    private static Properties loadProperties(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        try (InputStream is = in;){
            Properties properties;
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                Properties p = new Properties();
                p.load(reader);
                properties = p;
            }
            return properties;
        }
    }

    private static Properties loadExternalIfPresent(File externalFile) throws IOException {
        Properties p = new Properties();
        if (externalFile.isFile()) {
            try (FileInputStream in = new FileInputStream(externalFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                p.load(reader);
            }
        }
        return p;
    }

    private static void writeExternal(File externalFile, Properties properties) throws IOException {
        File parent = externalFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory: " + parent.getAbsolutePath());
        }
        try (FileOutputStream out = new FileOutputStream(externalFile, false);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            TimeFormatRegistry.writeExternal(properties, writer);
        }
    }

    private static void writeExternal(Properties props, Writer writer) throws IOException {
        writer.write(TimeFormatHeader.get());
        ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(keys);
        for (String key : keys) {
            writer.write(key + "=" + props.getProperty(key) + "\n");
        }
    }
}

