/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.security.GeneralSecurityException;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class SecretKeySerializer
implements ObjectSerializer<SecretKey> {
    @Override
    public boolean supports(@NonNull Class<? super SecretKey> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SecretKey.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull SecretKey key, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        byte[] raw = key.getEncoded();
        if (raw == null) {
            throw new IllegalArgumentException("SecretKey#getEncoded returned null");
        }
        data.setValue(Base64.getEncoder().encodeToString(raw));
    }

    @Override
    public SecretKey deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        byte[] raw;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String token = data.getValue(String.class);
        if (token == null || token.isEmpty()) {
            return null;
        }
        String base64 = token.trim();
        try {
            raw = Base64.getDecoder().decode(base64);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Base64 for SecretKey", e);
        }
        try {
            switch (raw.length) {
                case 8: {
                    DESKeySpec spec = new DESKeySpec(raw);
                    return SecretKeyFactory.getInstance("DES").generateSecret(spec);
                }
                case 16: 
                case 24: 
                case 32: {
                    return new SecretKeySpec(raw, "AES");
                }
            }
            throw new IllegalArgumentException("Unsupported key length: " + raw.length + " (expected 8b for DES or 16b/24b/32b for AES)");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to rebuild SecretKey: " + e.getMessage(), e);
        }
    }
}

