/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.time.Duration;
import dev.jsinco.brewery.time.TimeUtil;
import java.util.Set;
import lombok.NonNull;

public class MinutesDurationSerializer
implements ObjectSerializer<Duration.Minutes> {
    @Override
    public boolean supports(@NonNull Class<? super Duration.Minutes> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Duration.Minutes.class == type;
    }

    @Override
    public void serialize(@NonNull Duration.Minutes object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(TimeUtil.minimalString(object.durationTicks(), TimeUtil.TimeUnit.MINUTES, Set.of(TimeUtil.TimeUnit.AGING_YEARS, TimeUtil.TimeUnit.COOKING_MINUTES)));
    }

    @Override
    public Duration.Minutes deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String durationString = data.getValue(String.class);
        if (durationString == null) {
            return new Duration.Minutes(0L);
        }
        return new Duration.Minutes(TimeUtil.parse(durationString, TimeUtil.TimeUnit.MINUTES));
    }
}

