/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.configuration.BarrelSection;
import dev.jsinco.brewery.configuration.CauldronSection;
import dev.jsinco.brewery.configuration.SoundSection;
import dev.jsinco.brewery.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.Generated;

public class Config
extends OkaeriConfig {
    @Comment(value={"Config version. Don't change this"})
    @CustomKey(value="config-version")
    private int configVersion = 1;
    @Comment(value={"What language file should we use? See: /TheBrewingProject/locale"})
    @CustomKey(value="language")
    private Locale language = Locale.US;
    @Comment(value={"Allow hoppers to interact with distilleries and barrels"})
    @CustomKey(value="automation-enabled")
    private boolean automation = true;
    @Comment(value={"Whether an ingredient can be added into a brew regardless if it's not in any of the recipes"})
    @CustomKey(value="allow-unregistered-ingredients")
    private boolean allowUnregisteredIngredients = false;
    @Comment(value={"Whether items should be consumed when in creative mode when using it on tbp structures"})
    @CustomKey(value="consume-items-in-creative")
    private boolean consumeItemsInCreative = false;
    @Comment(value={"Whether everything non-item related should be translated to the players locale"})
    @CustomKey(value="client-side-translations")
    private boolean clientSideTranslations = false;
    @Comment(value={"Some clients and tools allow players to see the NBT data of an item, which, for our potions, includes", "all the brewing steps it went through. Encrypt this data to prevent it from being abused as a recipe?"})
    @CustomKey(value="encrypt-sensitive-data")
    private boolean encryptSensitiveData = true;
    @Comment(value={"The key that is going to be used for the encryption, this is unique per server"})
    private SecretKey encryptionKey = Config.generateAesKey();
    @Comment(value={"A list of previous keys to try when decryption with the current one fails"})
    private List<SecretKey> previousEncryptionKeys = List.of();
    @Comment(value={"Should we re-encrypt all items in opened inventories to use the newest encryption standard and the latest key?", "If your encryption key got leaked, use this to prevent anyone from seeing items encrypted with old keys ever again"})
    private boolean reencryptItemsInInventories = false;
    @CustomKey(value="empty-any-drink-using-hopper")
    @Comment(value={"Empty any drink when right-clicking a hopper. If false, only applies to failed brews"})
    private boolean emptyAnyDrinkUsingHopper = false;
    @CustomKey(value="cauldrons")
    private CauldronSection cauldrons = new CauldronSection();
    @CustomKey(value="barrels")
    private BarrelSection barrels = new BarrelSection();
    @Comment(value={"This field accepts either a single sound definition or a list of definitions.", "If a list is provided, one sound will be chosen randomly.", "", "A single sound entry is a string with one of the following formats", "- <sound_id>", "- <sound_id>/<pitch>", "- <sound_id>/<min_pitch>;<max_pitch>", "", "See the default values below for examples"})
    @CustomKey(value="sounds")
    private SoundSection sounds = new SoundSection();
    @CustomKey(value="command-aliases")
    @Comment(value={"The aliases for the 'tbp' command"})
    private List<String> commandAliases = List.of("brewery", "brew");
    @Exclude
    private static Config instance;

    public static void load(File dataFolder, OkaeriSerdesPack ... packs) {
        instance = ConfigManager.create(Config.class, it -> {
            it.withConfigurer(new YamlSnakeYamlConfigurer(), packs);
            it.withBindFile(new File(dataFolder, "config.yml"));
            it.withRemoveOrphans(true);
            it.saveDefaults();
            it.load(true);
        });
    }

    public static Config config() {
        return instance;
    }

    public static SecretKey generateAesKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            try {
                kg.init(256, SecureRandom.getInstanceStrong());
            }
            catch (Exception ignored) {
                kg.init(128, new SecureRandom());
            }
            return kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey generateDesKey() {
        try {
            return KeyGenerator.getInstance("DES").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public int configVersion() {
        return this.configVersion;
    }

    @Generated
    public Locale language() {
        return this.language;
    }

    @Generated
    public boolean automation() {
        return this.automation;
    }

    @Generated
    public boolean allowUnregisteredIngredients() {
        return this.allowUnregisteredIngredients;
    }

    @Generated
    public boolean consumeItemsInCreative() {
        return this.consumeItemsInCreative;
    }

    @Generated
    public boolean clientSideTranslations() {
        return this.clientSideTranslations;
    }

    @Generated
    public boolean encryptSensitiveData() {
        return this.encryptSensitiveData;
    }

    @Generated
    public SecretKey encryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public List<SecretKey> previousEncryptionKeys() {
        return this.previousEncryptionKeys;
    }

    @Generated
    public boolean reencryptItemsInInventories() {
        return this.reencryptItemsInInventories;
    }

    @Generated
    public boolean emptyAnyDrinkUsingHopper() {
        return this.emptyAnyDrinkUsingHopper;
    }

    @Generated
    public CauldronSection cauldrons() {
        return this.cauldrons;
    }

    @Generated
    public BarrelSection barrels() {
        return this.barrels;
    }

    @Generated
    public SoundSection sounds() {
        return this.sounds;
    }

    @Generated
    public List<String> commandAliases() {
        return this.commandAliases;
    }
}

