/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.util.HolderProvider;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;

public class HolderProviderImpl
implements HolderProvider {
    @Override
    public Optional<Holder.Material> material(String materialString) {
        return Optional.ofNullable(NamespacedKey.fromString((String)materialString)).filter(key -> Registry.MATERIAL.get(key) != null).map(key -> new Holder.Material(BukkitAdapter.toBreweryKey(key)));
    }

    @Override
    public Optional<Holder.Player> player(UUID playerUuid) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)playerUuid)).map(ignored -> new Holder.Player(playerUuid));
    }

    @Override
    public Optional<Holder.World> world(UUID worldUuid) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)worldUuid)).map(ignored -> new Holder.World(worldUuid));
    }

    @Override
    public Set<Holder.Material> parseTag(String tagString) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)tagString);
        if (namespacedKey == null) {
            return Set.of();
        }
        Tag materialTag = Bukkit.getTag((String)"blocks", (NamespacedKey)namespacedKey, Material.class);
        return Optional.ofNullable(materialTag).stream().map(Tag::getValues).flatMap(Collection::stream).map(BukkitAdapter::toMaterialHolder).collect(Collectors.toUnmodifiableSet());
    }
}

