/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.bukkit.structure.BlockDataMatcher;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.Schematic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class BreweryStructure {
    private final Schematic schem;
    private final List<Vector3i> entryPoints;
    private final String name;
    private final Map<StructureMeta<?>, Object> structureMeta;

    public BreweryStructure(@NotNull Schematic schem, @NotNull String name, Map<StructureMeta<?>, Object> structureMeta) {
        this(schem, BreweryStructure.computeOrigins(schem), name, structureMeta);
    }

    public BreweryStructure(@NotNull Schematic schem, @NotNull List<Vector3i> origins, @NotNull String name, Map<StructureMeta<?>, Object> structureMeta) {
        this.schem = Objects.requireNonNull(schem);
        this.entryPoints = origins;
        this.name = Objects.requireNonNull(name);
        this.structureMeta = Objects.requireNonNull(structureMeta);
        structureMeta.forEach((key, value) -> Preconditions.checkArgument((boolean)key.validator().test(value), (Object)("Invalid structure '" + name + "': value '" + String.valueOf(value) + "' is not allowed for meta: " + String.valueOf(structureMeta))));
        StructureType type = this.getMeta(StructureMeta.TYPE);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("Invalid structure '" + name + "', missing meta: " + String.valueOf(StructureMeta.TYPE)));
        List<StructureMeta<?>> missing = type.getMissingMandatory(structureMeta.keySet());
        missing.forEach(missingEntry -> structureMeta.put((StructureMeta<?>)missingEntry, missingEntry.defaultValue()));
    }

    private static List<Vector3i> computeOrigins(Schematic schem) {
        ArrayList vector3iList = new ArrayList();
        schem.apply(new Matrix3d(), (position, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            vector3iList.add(position);
        });
        return List.copyOf(vector3iList);
    }

    public <T> Optional<Location> findValidOrigin(Matrix3d transformation, Location entryPoint, BlockDataMatcher<T> blockDataMatcher, T matcherType) {
        Preconditions.checkNotNull((Object)entryPoint.getWorld(), (Object)"World for entry point can not be null!");
        for (Vector3i structureEntryPoint : this.entryPoints) {
            Vector3d transformedEntryPoint = transformation.transform(new Vector3d((Vector3ic)structureEntryPoint));
            Location worldOrigin = entryPoint.clone().subtract((double)((int)transformedEntryPoint.x()), (double)((int)transformedEntryPoint.y()), (double)((int)transformedEntryPoint.z()));
            if (!this.matches(transformation, worldOrigin, blockDataMatcher, matcherType)) continue;
            return Optional.of(worldOrigin);
        }
        return Optional.empty();
    }

    private <T> boolean matches(Matrix3d transformation, Location structureWorldOrigin, BlockDataMatcher<T> blockDataMatcher, T matcherType) {
        Map<Location, BlockData> expectedBlocks = this.getExpectedBlocks(transformation, structureWorldOrigin);
        for (Map.Entry<Location, BlockData> expected : expectedBlocks.entrySet()) {
            World world = expected.getKey().getWorld();
            if (!world.getWorldBorder().isInside(expected.getKey()) || world.getMinHeight() > expected.getKey().getBlockY() || world.getMaxHeight() <= expected.getKey().getBlockY()) {
                return false;
            }
            if (blockDataMatcher.matches(expected.getKey().getBlock().getBlockData(), expected.getValue(), matcherType)) continue;
            return false;
        }
        return true;
    }

    public Map<Location, BlockData> getExpectedBlocks(Matrix3d transformation, Location structureWorldOrigin) {
        Preconditions.checkNotNull((Object)structureWorldOrigin.getWorld(), (Object)"World for world origin can not be null!");
        HashMap<Location, BlockData> output = new HashMap<Location, BlockData>();
        this.schem.apply(transformation, (schematicSpacePosition, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            output.put(structureWorldOrigin.clone().add((double)schematicSpacePosition.x(), (double)schematicSpacePosition.y(), (double)schematicSpacePosition.z()), (BlockData)blockData);
        });
        return output;
    }

    public List<BlockData> getPalette() {
        return Arrays.asList(this.schem.palette());
    }

    @Nullable
    public <V> V getMeta(StructureMeta<V> meta) {
        return (V)this.structureMeta.get(meta);
    }

    public <V> V getMetaOrDefault(StructureMeta<V> meta, V defaultValue) {
        return (V)this.structureMeta.getOrDefault(meta, defaultValue);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

