/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.step;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.step.Condition;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConditionalStepExecutable
implements EventPropertyExecutable {
    private final Condition condition;

    public ConditionalStepExecutable(Condition condition) {
        this.condition = condition;
    }

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        return this.shouldCancel(contextPlayer, this.condition) ? EventPropertyExecutable.ExecutionResult.STOP_EXECUTION : EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    private boolean shouldCancel(UUID contextPlayer, Condition condition) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return true;
        }
        Condition condition2 = condition;
        Objects.requireNonNull(condition2);
        Condition condition3 = condition2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Condition.Died.class, Condition.HasPermission.class, Condition.JoinedServer.class, Condition.JoinedWorld.class, Condition.TookDamage.class, Condition.ModifierAbove.class, Condition.NotCondition.class}, (Object)condition3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Condition.Died died = (Condition.Died)condition3;
                if (!player.isDead()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Condition.HasPermission hasPermission = (Condition.HasPermission)condition3;
                if (!player.hasPermission(hasPermission.permission())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Condition.JoinedServer joinedServer = (Condition.JoinedServer)condition3;
                yield false;
            }
            case 3 -> {
                Condition.JoinedWorld joinedWorld = (Condition.JoinedWorld)condition3;
                if (!player.getWorld().getName().equals(joinedWorld.worldName())) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                Condition.TookDamage tookDamage = (Condition.TookDamage)condition3;
                yield true;
            }
            case 5 -> {
                Condition.ModifierAbove modifierAbove = (Condition.ModifierAbove)condition3;
                DrunkState state = ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).getDrunkState(contextPlayer);
                if (state == null) {
                    yield true;
                }
                if (state.modifierValue(modifierAbove.modifier()) < modifierAbove.value()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                Condition.NotCondition notCondition = (Condition.NotCondition)condition3;
                yield !this.shouldCancel(contextPlayer, notCondition.toInvert());
            }
        };
    }
}

