/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PassOutNamedExecutable
implements EventPropertyExecutable {
    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null || player.hasPermission("brewery.override.kick")) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        EventSection.KickEventSection kickEventSection = EventSection.events().kickEvent();
        TranslatableComponent playerKickMessage = kickEventSection.kickEventMessage() == null ? Component.translatable((String)"tbp.events.default-kick-event-message") : MessageUtil.miniMessage(kickEventSection.kickEventMessage(), BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player));
        player.kick(GlobalTranslator.render((Component)playerKickMessage, (Locale)Config.config().language()));
        if (kickEventSection.kickServerMessage() != null) {
            Component message = MessageUtil.miniMessage(kickEventSection.kickServerMessage(), BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player));
            Bukkit.getOnlinePlayers().forEach(audience -> audience.sendMessage(message));
        }
        ((DrunksManagerImpl)drunksManager).registerPassedOut(player.getUniqueId());
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }
}

