/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.configuration.EventSection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DrunkMessageNamedExecutable
implements EventPropertyExecutable {
    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        List<String> drunkMessages = EventSection.events().drunkMessages();
        if (drunkMessages.isEmpty()) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        List<Player> onlinePlayers = Bukkit.getOnlinePlayers().stream().filter(Entity::isVisibleByDefault).filter(player1 -> !player.equals(player1)).map(Player.class::cast).toList();
        if (onlinePlayers.isEmpty()) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        Player randomPlayer = onlinePlayers.get(RANDOM.nextInt(onlinePlayers.size()));
        player.chat(drunkMessages.get(RANDOM.nextInt(drunkMessages.size())).replace("<random_player_name>", randomPlayer.getName()));
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }
}

