/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.vector;

import dev.jsinco.brewery.api.vector.BreweryVector;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record BreweryLocation(int x, int y, int z, UUID worldUuid) {
    public BreweryVector toVector() {
        return new BreweryVector(this.x, this.y, this.z);
    }

    public BreweryLocation add(int x, int y, int z) {
        return new BreweryLocation(x + this.x(), y + this.y(), z + this.z(), this.worldUuid);
    }

    @ApiStatus.Internal
    public record Uncompiled(int x, int y, int z, String worldIdentifier) {
        public Optional<BreweryLocation> get(Function<String, @Nullable UUID> worldUuidFunction) {
            return Optional.ofNullable(worldUuidFunction.apply(this.worldIdentifier)).map(worldUuid -> new BreweryLocation(this.x, this.y, this.z, (UUID)worldUuid));
        }

        public Stream<BreweryLocation> stream(Function<String, @Nullable UUID> worldUuidFunction) {
            return this.get(worldUuidFunction).stream();
        }
    }
}

